;Copyright (C) 2025 Advanced Micro Devices, Inc. All rights reserved.
;=================================================
; Camera sensor I2C group control API
;
; [void] SensorGroupHold(void)
; [void] SensorGroupRelease(void)
;=================================================
.function SensorGroupHold
WI2C $0x031d, $0x01, $1
.endfunction

.function SensorGroupRelease
WI2C $0x031d, $0x00, $1
.endfunction

;=================================================
; Camera sensor exposure control API
;
; [uint32 setGain]  SensorConvertAGain(uint32 aGain, uint32 *aGainReal, uint32 *aGainSetting)
;=================================================
.function SensorConvertAGain

;R0 is the aGain
;gain_reg
;reg addr:0x00d0 0x0d02 0x0d03 0x00b8 0x00b9
;group0 :analog gain,1000, reg{0x00,0x00,0x00,0x01,0x00},
;group1 :analog gain,1181, reg{0x00,0x00,0x50,0x01,0x0c},
;group2 :analog gain,1410, reg{0x00,0x02,0x00,0x01,0x1a},
;group3 :analog gain,1941, reg{0x00,0x04,0x00,0x02,0x00},
;group4 :analog gain,2292, reg{0x00,0x04,0x50,0x02,0x18},
;group5 :analog gain,2714, reg{0x00,0x06,0x00,0x02,0x34},
;group6 :analog gain,3205, reg{0x00,0x06,0x50,0x03,0x14},
;group7 :analog gain,3704, reg{0x00,0x08,0x00,0x04,0x00},
;group8 :analog gain,4374, reg{0x00,0x08,0x50,0x04,0x1e},
;group9 :analog gain,5069, reg{0x00,0x0a,0x00,0x05,0x26},
;group10:analog gain,5986, reg{0x00,0x0a,0x50,0x06,0x29},
;group11:analog gain,6730, reg{0x00,0x0c,0x00,0x08,0x00},
;group12:analog gain,7947, reg{0x00,0x0c,0x50,0x09,0x1f},
;group13:analog gain,10644,reg{0x00,0x0b,0x00,0x0b,0x0d},
;group14:analog gain,11839,reg{0x01,0x0a,0x50,0x0d,0x11},
;group15:analog gain,13334,reg{0x00,0x0d,0x00,0x10,0x00},
;group16:analog gain,18551,reg{0x01,0x0c,0x92,0x16,0x1a},

SUB R9, R0, $1000
JGEZ R9 @Group0
JLZ R9 @Less1000

Group0:
SUB R9, R0, $1181
JGEZ R9 @Group1
;1000<=R0<1181
	MOVB R6, $0
	MOVDW R7, $1000
	JNZ $1 @End

Group1:
SUB R9, R0, $1410
JGEZ R9 @Group2
;1181<=R0<1410
	MOVB R6, $1
	MOVDW R7, $1181
	JNZ $1 @End

Group2:
SUB R9, R0, $1941
JGEZ R9 @Group3
;1410<=R0<1941
	MOVB R6, $2
	MOVDW R7, $1410
	JNZ $1 @End

Group3:
SUB R9, R0, $2292
JGEZ R9 @Group4
;1941<=R0<2292
	MOVB R6, $3
	MOVDW R7, $1941
	JNZ $1 @End

Group4:
SUB R9, R0, $2714
JGEZ R9 @Group5
;2292<=R0<2714
	MOVB R6, $4
	MOVDW R7, $2292
	JNZ $1 @End

Group5:
SUB R9, R0, $3205
JGEZ R9 @Group6
;2714<=R0<3205
	MOVB R6, $5
	MOVDW R7, $2714
	JNZ $1 @End

Group6:
SUB R9, R0, $3704
JGEZ R9 @Group7
;3205<=R0<3704
	MOVB R6, $6
	MOVDW R7, $3205
	JNZ $1 @End

Group7:
SUB R9, R0, $4374
JGEZ R9 @Group8
;3704<=R0<4374
	MOVB R6, $7
	MOVDW R7, $3704
	JNZ $1 @End

Group8:
SUB R9, R0, $5069
JGEZ R9 @Group9
;4374<=R0<5069
	MOVB R6, $8
	MOVDW R7, $4374
	JNZ $1 @End

Group9:
SUB R9, R0, $5986
JGEZ R9 @Group10
;5069<=R0<5986
	MOVB R6, $9
	MOVDW R7, $5069
	JNZ $1 @End

Group10:
SUB R9, R0, $6730
JGEZ R9 @Group11
;5986<=R0<6730
	MOVB R6, $10
	MOVDW R7, $5986
	JNZ $1 @End

Group11:
SUB R9, R0, $7947
JGEZ R9 @Group12
;6730<=R0<7947
	MOVB R6, $11
	MOVDW R7, $6730
	JNZ $1 @End

Group12:
SUB R9, R0, $10044
JGEZ R9 @Group13
;7947<=R0<10044
	MOVB R6, $12
	MOVDW R7, $7947
	JNZ $1 @End

Group13:
SUB R9, R0, $11839
JGEZ R9 @Group14
;10044<=R0<11839
	MOVB R6, $13
	MOVDW R7, $10044
	JNZ $1 @End

Group14:
SUB R9, R0, $13334
JGEZ R9 @Group15
;11839<=R0<13334
	MOVB R6, $14
	MOVDW R7, $11839
	JNZ $1 @End

Group15:
SUB R9, R0, $18551
JGEZ R9 @Group15
;13334<=R0<18551
	MOVB R6, $15
	MOVDW R7, $13334
	JNZ $1 @End

Group16:
;18551<=R0
	MOVB R6, $16
	MOVDW R7, $18551
	JNZ $1 @End

Less1000:
	MOVB R6, $0
	MOVB R7, $1000
	JNZ $1 @End

End:
	MOVDW R1, R6
	MOVDW R0, R7
.endfunction

;=================================================
; Camera sensor exposure control API
;
; [uint32 setGain]  SensorSetAGain(uint32 aGainSetting)
; GC1029 doesn't has analog gain formula, so R0 is not register value.
; R0 is group number of analog gain register
;=================================================
.function SensorSetAGain
;R0 is group number of aGainSetting
;reg addr:0x00d0 0x0d02 0x0d03 0x00b8 0x00b9
;group0 :analog gain,1000, reg{0x00,0x00,0x00,0x01,0x00},
;group1 :analog gain,1181, reg{0x00,0x00,0x50,0x01,0x0c},
;group2 :analog gain,1410, reg{0x00,0x02,0x00,0x01,0x1a},
;group3 :analog gain,1941, reg{0x00,0x04,0x00,0x02,0x00},
;group4 :analog gain,2292, reg{0x00,0x04,0x50,0x02,0x18},
;group5 :analog gain,2714, reg{0x00,0x06,0x00,0x02,0x34},
;group6 :analog gain,3205, reg{0x00,0x06,0x50,0x03,0x14},
;group7 :analog gain,3704, reg{0x00,0x08,0x00,0x04,0x00},
;group8 :analog gain,4374, reg{0x00,0x08,0x50,0x04,0x1e},
;group9 :analog gain,5069, reg{0x00,0x0a,0x00,0x05,0x26},
;group10:analog gain,5986, reg{0x00,0x0a,0x50,0x06,0x29},
;group11:analog gain,6730, reg{0x00,0x0c,0x00,0x08,0x00},
;group12:analog gain,7947, reg{0x00,0x0c,0x50,0x09,0x1f},
;group13:analog gain,10644,reg{0x00,0x0b,0x00,0x0b,0x0d},
;group14:analog gain,11839,reg{0x01,0x0a,0x50,0x0d,0x11},
;group15:analog gain,13334,reg{0x00,0x0d,0x00,0x10,0x00},
;group16:analog gain,18551,reg{0x01,0x0c,0x92,0x16,0x1a},

SUB R9, R0, $0
JGZ R9 @Group1
;R0-0=0
	MOVB R10, $0x00
	MOVB R11, $0x00
	MOVB R12, $0x00
	MOVB R13, $0x01
	MOVB R14, $0x00
	MOVB R15, $0x20
	JNZ $1 @WriteReg

Group1:
SUB R9, R0, $1
JGZ R9 @Group2
;R0-1=0
	MOVB R10, $0x00
	MOVB R11, $0x00
	MOVB R12, $0x50
	MOVB R13, $0x01
	MOVB R14, $0x0c
	MOVB R15, $0x22
	JNZ $1 @WriteReg

Group2:
SUB R9, R0, $2
JGZ R9 @Group3
;R0-2=0
	MOVB R10, $0x00
	MOVB R11, $0x02
	MOVB R12, $0x00
	MOVB R13, $0x01
	MOVB R14, $0x1a
	MOVB R15, $0x23
	JNZ $1 @WriteReg

Group3:
SUB R9, R0, $3
JGZ R9 @Group4
;R0-3=0
	MOVB R10, $0x00
	MOVB R11, $0x04
	MOVB R12, $0x00
	MOVB R13, $0x02
	MOVB R14, $0x00
	MOVB R15, $0x25
	JNZ $1 @WriteReg

Group4:
SUB R9, R0, $4
JGZ R9 @Group5
;R0-4=0
	MOVB R10, $0x00
	MOVB R11, $0x04
	MOVB R12, $0x50
	MOVB R13, $0x02
	MOVB R14, $0x18
	MOVB R15, $0x28
	JNZ $1 @WriteReg

Group5:
SUB R9, R0, $5
JGZ R9 @Group6
;R0-5=0
	MOVB R10, $0x00
	MOVB R11, $0x06
	MOVB R12, $0x00
	MOVB R13, $0x02
	MOVB R14, $0x34
	MOVB R15, $0x2a
	JNZ $1 @WriteReg
	
Group6:
SUB R9, R0, $6
JGZ R9 @Group7
;R0-6=0
	MOVB R10, $0x00
	MOVB R11, $0x06
	MOVB R12, $0x50
	MOVB R13, $0x03
	MOVB R14, $0x14
	MOVB R15, $0x2d
	JNZ $1 @WriteReg
	
Group7:
SUB R9, R0, $7
JGZ R9 @Group8
;R0-7=0
	MOVB R10, $0x00
	MOVB R11, $0x08
	MOVB R12, $0x00
	MOVB R13, $0x04
	MOVB R14, $0x00
	MOVB R15, $0x2e
	JNZ $1 @WriteReg
	
Group8:
SUB R9, R0, $8
JGZ R9 @Group9
;R0-8=0
	MOVB R10, $0x00
	MOVB R11, $0x08
	MOVB R12, $0x50
	MOVB R13, $0x04
	MOVB R14, $0x1e
	MOVB R15, $0x30
	JNZ $1 @WriteReg

Group9:
SUB R9, R0, $9
JGZ R9 @Group10
;R0-9=0
	MOVB R10, $0x00
	MOVB R11, $0x0a
	MOVB R12, $0x00
	MOVB R13, $0x05
	MOVB R14, $0x26
	MOVB R15, $0x34
	JNZ $1 @WriteReg
	
Group10:
SUB R9, R0, $10
JGZ R9 @Group11
;R0-10=0
	MOVB R10, $0x00
	MOVB R11, $0x0a
	MOVB R12, $0x50
	MOVB R13, $0x06
	MOVB R14, $0x29
	MOVB R15, $0x37
	JNZ $1 @WriteReg

Group11:
SUB R9, R0, $11
JGZ R9 @Group12
;R0-11=0
	MOVB R10, $0x00
	MOVB R11, $0x0c
	MOVB R12, $0x00
	MOVB R13, $0x08
	MOVB R14, $0x00
	MOVB R15, $0x39
	JNZ $1 @WriteReg

Group12:
SUB R9, R0, $12
JGZ R9 @Group13
;R0-12=0
	MOVB R10, $0x00
	MOVB R11, $0x0c
	MOVB R12, $0x50
	MOVB R13, $0x09
	MOVB R14, $0x1f
	MOVB R15, $0x3e
	JNZ $1 @WriteReg

Group13:
SUB R9, R0, $13
JGZ R9 @Group14
;R0-13=0
	MOVB R10, $0x00
	MOVB R11, $0x0b
	MOVB R12, $0x00
	MOVB R13, $0x0b
	MOVB R14, $0x0d
	MOVB R15, $0x40
	JNZ $1 @WriteReg

Group14:
SUB R9, R0, $14
JGZ R9 @Group15
;R0-14=0
	MOVB R10, $0x01
	MOVB R11, $0x0a
	MOVB R12, $0x50
	MOVB R13, $0x0d
	MOVB R14, $0x11
	MOVB R15, $0x43
	JNZ $1 @WriteReg

Group15:
SUB R9, R0, $15
JGZ R9 @Group16
;R0-15=0
	MOVB R10, $0x00
	MOVB R11, $0x0d
	MOVB R12, $0x00
	MOVB R13, $0x10
	MOVB R14, $0x00
	MOVB R15, $0x48
	JNZ $1 @WriteReg

Group16:
;R0-16>=0
	MOVB R10, $0x01
	MOVB R11, $0x0c
	MOVB R12, $0x92
	MOVB R13, $0x16
	MOVB R14, $0x1a
	MOVB R15, $0x48
	JNZ $1 @WriteReg

WriteReg:
	WI2C $0xd0, R10, $1
	WI2C $0xd02, R11, $1
	WI2C $0xd03, R12, $1
	WI2C $0xb8, R13, $1
	WI2C $0xb9, R14, $1
	WI2C $0x80, R15, $1
.endfunction

;=================================================
; Camera sensor exposure control API
;
;=================================================
.function SensorGetAGain


.endfunction

;=================================================
; Camera sensor exposure control API
;
; [uint32 setItime] SensorSetItime(uint32 iTimeSetting,
;                                  uint32 durationSetting)
;R0 is the iTimeSetting,exposure line
;R1 is the durationSetting,vts,frame_length_line
;R6: first_frame_length_lines
;R31: save the current_frame_length_lines
;=================================================
.function SensorSetItime
JNZ R31 @FL_UPDATED
MOVDW R31, R6               ;R31 = R6;
FL_UPDATED:
SUB R30, R1, R31            ;R30 = R1 - R31 = durationSetting(frame_length_line) - current_frame_length_lines
MOVDW R31, R1               ;R31 = R1

SHR R9, R1, $8             ;R1 = frame_length_line
AND R9, R9, $0x3f          ;R9 = frame_length_line_high = (frame_length_line >> 8) & 0x3f
AND R10, R1, $0xff         ;R10 = frame_length_line_l = frame_length_line & 0xff
SHR R15, R0, $8            ;R0  = line_count
AND R15, R15, $0x3f        ;R15 = line_count_h = (line_count >> 8) & 0x3f
AND R16, R0, $0xff         ;R16 = line_count_l = line_count & 0xff

JLZ R30 @LINE_COUNT_FIRST  ;durationSetting is smaller than current_frame_length_lines
	WI2C $0x0641, R9, $1
	WI2C $0x0642, R10, $1
	WI2C $0x0603, R15, $1
	WI2C $0x0604, R16, $1
JGZ $1 @END                ;Jump to end

LINE_COUNT_FIRST:
	WI2C $0x0603, R15, $1
	WI2C $0x0604, R16, $1
	WI2C $0x0641, R9, $1
	WI2C $0x0642, R10, $1
END:
;Note, the setted new Gain and new Itime must be return in R0 and R1
;Here, we just return the input value.
MOVDW R0, R0
.endfunction

;=================================================
; Camera sensor exposure control API
;
;=================================================
 .function SensorGetItime 

.endfunction

;===================================================
; Camera sensor Digital Gain control API
; Empty for now
;===================================================
.function SensorSetDGain

.endfunction

;===================================================
; Camera sensor Digital Gain control API
; Empty for now
;===================================================
.function SensorGetDGain
.endfunction
