@echo off
setlocal enableextensions
setlocal enabledelayedexpansion
%SystemRoot%\System32\chcp.com 437 > NUL 2>&1

rem //-------------------------------------------------------------------------
rem // ATTENTION: must be run from BIN_FOLDER! This will be checked.
rem //-------------------------------------------------------------------------

rem //-------------------------------------------------------------------------
rem // Configurations.
rem //-------------------------------------------------------------------------

rem //-------------------------------------------------------------------------
rem // Install mode.
rem //-------------------------------------------------------------------------
set INSTALL_DISABLED=NO

rem //-------------------------------------------------------------------------
rem // Debug & execution settings.
rem //-------------------------------------------------------------------------
set DEBUG=YES
set EXECUTE=YES
set /A COMMANDS_COUNT=0
set TIME_OUT_IN_S=1

rem //-------------------------------------------------------------------------
rem // CMD path.
rem // Explicitly define COMSPEC and cmd.exe variable paths.
rem //-------------------------------------------------------------------------
set CMD_EXE=%SystemRoot%\System32\cmd.exe
set CMDLINE="%CMD_EXE%"
set COMSPEC=%CMD_EXE%

rem //-------------------------------------------------------------------------
rem // Customer settings.
rem //-------------------------------------------------------------------------
set CUSTOMER_UC_NAME=QUEENCREEK
set CUSTOMER_ID=%CUSTOMER_UC_NAME%
set CONSENT_RUNTIME_DEP_NAME=ICIP
set CUSTOMER_SERVICE_PORT=49350
set CUSTOMER_TASK_START_PORT=49351

rem //-------------------------------------------------------------------------
rem // Folders settings.
rem // ATTENTION: several folders must be provided in 2 forms: with and 
rem // without double-backslashes (a.k.a. as ESCAPED).
rem // Use ESRV V-Table variables
rem //-------------------------------------------------------------------------
set BIN_FOLDER=%SYSTEMDRIVE%\Program Files\Intel\SUR\%CUSTOMER_UC_NAME%\x64
set SERVICE_RESOLVED_OUTPUTS_FOLDER=%LOCALAPPDATA%\Intel\SUR\%CUSTOMER_UC_NAME%\intermediate_data
set ESCAPED_APP_LOCAL_DATA_VARIABLE=%%LOCAL_APP_DATA%%
set SERVICE_OUTPUTS_HEAD_FOLDER=%ESCAPED_APP_LOCAL_DATA_VARIABLE%\Intel\SUR\%CUSTOMER_UC_NAME%
set SERVICE_OUTPUTS_FOLDER=%SERVICE_OUTPUTS_HEAD_FOLDER%\intermediate_data
set SERVICE_UPLOAD_FOLDER=%SERVICE_OUTPUTS_HEAD_FOLDER%\collected_data
set TASK_OUTPUTS_HEAD_FOLDER=%ESCAPED_APP_LOCAL_DATA_VARIABLE%\Intel\SUR\%CUSTOMER_UC_NAME%
set TASK_OUTPUTS_FOLDER=%TASK_OUTPUTS_HEAD_FOLDER%\intermediate_data
set TASK_UPLOAD_FOLDER=%TASK_OUTPUTS_HEAD_FOLDER%\collected_data
rem //-------------------------------------------------------------------------
set ESCAPED_BIN_FOLDER=%SYSTEMDRIVE%\\Program Files\\Intel\\SUR\\%CUSTOMER_UC_NAME%\\x64
set SERVICE_ESCAPED_OUTPUTS_HEAD_FOLDER=%ESCAPED_APP_LOCAL_DATA_VARIABLE%\\Intel\\SUR\\%CUSTOMER_UC_NAME%
set SERVICE_ESCAPED_OUTPUTS_FOLDER=%SERVICE_ESCAPED_OUTPUTS_HEAD_FOLDER%\\intermediate_data
set SERVICE_ESCAPED_UPLOAD_FOLDER=%SERVICE_ESCAPED_OUTPUTS_HEAD_FOLDER%\\collected_data
set TASK_ESCAPED_OUTPUTS_HEAD_FOLDER=%ESCAPED_APP_LOCAL_DATA_VARIABLE%\\Intel\\SUR\\%CUSTOMER_UC_NAME%
set TASK_ESCAPED_OUTPUTS_FOLDER=%TASK_ESCAPED_OUTPUTS_HEAD_FOLDER%\\intermediate_data
set TASK_ESCAPED_UPLOAD_FOLDER=%TASK_ESCAPED_OUTPUTS_HEAD_FOLDER%\\collected_data
rem //-------------------------------------------------------------------------
set SEMA_DRIVER_FILE_NAME=semav6msr64.sys
set SEMA_DRIVER_SERVICE_NAME=semav6msr64
set SEMA_SERVICE_NAME=SEMA

rem //-------------------------------------------------------------------------
rem // Services and tasks common settings.
rem // Note:
rem //    These settings are assigned to service and task settings. This is a
rem // convenient way to keep settings identical between service and task. It
rem // is customer's responsibility to adapt these settings differently between
rem // the service and the task to obtain the appropriate behavior in the next
rem // settings sections.
rem //-------------------------------------------------------------------------


set NUMSAMPLES_TO_BUFFER=6
set SSTATES_CLOCK=5000
set COMMON_PAUSE_TIME_IN_MS=5000
set COMMON_RESUME_DELAY_IN_MS=30000
set COMMON_DELAYED_DCTL_IN_MS=5000
set COMMON_WATCHDOG_IN_SAMPLES=5
set COMMON_WATCHDOG_THRESHOLD_IN_CPU_UTILIZATION_IN_PERCENT=50
set COMMON_TIME_DATA=no
set COMMON_KEY_DATA=no
set COMMON_PERFORMANCE_DATA=no
set COMMON_IN_CYCLE_PERFORMANCE_DATA=no
set COMMON_ADDRESS_IPV4=127.0.0.1
set SERVICE_START_DEPENDENCY_FOLDER=%SERVICE_OUTPUTS_FOLDER%
set TASK_START_DEPENDENCY_FOLDER=%TASK_OUTPUTS_FOLDER%
set SERVICE_ESCAPED_START_DEPENDENCY_FOLDER=%SERVICE_ESCAPED_OUTPUTS_FOLDER%
set TASK_ESCAPED_START_DEPENDENCY_FOLDER=%TASK_ESCAPED_OUTPUTS_FOLDER%
set COMMON_START_DEPENDENCY_SIZE_LIMIT_IN_BYTES=262144000  
set COMMON_START_DEPENDENCY_FILECAP_COUNT=300   
set COMMON_START_DEPENDENCY_SCANTIME_LIMIT_IN_MS=40000 
set COMMON_START_DEPENDENCY_FOLDERDEPTH_LIMIT=20
set COMMON_DB_MAX_PAGE_COUNT=300000
set COMMON_DEPENDENCY_CHECK_PERIOD=3600000
set SERVICE_DEPENDENCY_OPTIONS=--depend_on_folder \"%SERVICE_ESCAPED_START_DEPENDENCY_FOLDER%\" --depend_on_folder_size_less_than %COMMON_START_DEPENDENCY_SIZE_LIMIT_IN_BYTES% --depend_on_folder_files_count_less_than %COMMON_START_DEPENDENCY_FILECAP_COUNT% --depend_on_folder_depth_less_than %COMMON_START_DEPENDENCY_FOLDERDEPTH_LIMIT% --depend_on_folder_scan_time_less_than %COMMON_START_DEPENDENCY_SCANTIME_LIMIT_IN_MS% --depend_check_period %COMMON_DEPENDENCY_CHECK_PERIOD%
set TASK_DEPENDENCY_OPTIONS=--depend_on_folder \"%TASK_ESCAPED_START_DEPENDENCY_FOLDER%\" --depend_on_folder_size_less_than %COMMON_START_DEPENDENCY_SIZE_LIMIT_IN_BYTES% --depend_on_folder_files_count_less_than %COMMON_START_DEPENDENCY_FILECAP_COUNT% --depend_on_folder_depth_less_than %COMMON_START_DEPENDENCY_FOLDERDEPTH_LIMIT% --depend_on_folder_scan_time_less_than %COMMON_START_DEPENDENCY_SCANTIME_LIMIT_IN_MS% --depend_check_period %COMMON_DEPENDENCY_CHECK_PERIOD%
set COMMON_LOGGER_MODELER_OPTIONS=deferred_logger_stop=yes
set SSTATES_DELAYED_RESUME_MS=%COMMON_RESUME_DELAY_IN_MS%
set BATTERY_STARTUP_DELAY=6
set CSME_STARTUP_DELAY=8
set CRASHLOG_STARTUP_DELAY=12
set DISPLAY_STARTUP_DELAY=14



rem //-------------------------------------------------------------------------
rem // Services settings.
rem //-------------------------------------------------------------------------
set START_DEPENDENCY_KEY=SOFTWARE\Intel\SUR\%CONSENT_RUNTIME_DEP_NAME%_RUN
set ESCAPED_START_DEPENDENCY_KEY=SOFTWARE\\Intel\\SUR\\%CONSENT_RUNTIME_DEP_NAME%_RUN

rem //-------------------------------------------------------------------------
rem // Esrv service settings.
rem //-------------------------------------------------------------------------
set SERVICE_NAME=ESRV_SVC_%CUSTOMER_UC_NAME%
set SERVICE_REGISTRY_KEY=HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\%SERVICE_NAME%
set SERVICE_REGISTRY_KEY_INSTALL_VALUE=%SERVICE_REGISTRY_KEY%\install
set SERVICE_PORT=%CUSTOMER_SERVICE_PORT%
set SERVICE_OUTPUT_FILE_NAME=w
set SERVICE_PAUSE_TIME_IN_MS=%COMMON_PAUSE_TIME_IN_MS%
set SERVICE_WATCHDOG_IN_SAMPLES=%COMMON_WATCHDOG_IN_SAMPLES%
set SERVICE_WATCHDOG_THRESHOLD_IN_CPU_UTILIZATION_IN_PERCENT=%COMMON_WATCHDOG_THRESHOLD_IN_CPU_UTILIZATION_IN_PERCENT%
set SERVICE_WATCHDOG_OPTIONS=--watchdog %SERVICE_WATCHDOG_IN_SAMPLES% --watchdog_cpu_usage_limit %SERVICE_WATCHDOG_THRESHOLD_IN_CPU_UTILIZATION_IN_PERCENT%
rem set SERVICE_WATCHDOG_OPTIONS=
set SERVICE_TIME_DATA=%COMMON_TIME_DATA%
set SERVICE_KEY_DATA=%COMMON_KEY_DATA%
set SERVICE_PERFORMANCE_DATA=%COMMON_PERFORMANCE_DATA%
set SERVICE_IN_CYCLE_PERFORMANCE_DATA=%COMMON_IN_CYCLE_PERFORMANCE_DATA%
set SERVICE_ADDRESS_IPV4=%COMMON_ADDRESS_IPV4%
set SERVICE_XLOADER_LOCK=yes
set SERVICE_DELAYED_DCTL_IN_MS=%COMMON_DELAYED_DCTL_IN_MS%

rem //-------------------------------------------------------------------------
rem // User esrv service settings.
rem //-------------------------------------------------------------------------
set USER_SERVICE_NAME=USER_ESRV_SVC_%CUSTOMER_UC_NAME%

rem //-------------------------------------------------------------------------
rem // Task settings.
rem //-------------------------------------------------------------------------
set TASK_NAME=USER_ESRV_SVC_%CUSTOMER_UC_NAME%
set TASK_DELAY=PT4M
set TASK_PRIORITY=2
set TASK_START_PORT=%CUSTOMER_TASK_START_PORT%
set TASK_OUTPUT_FILE_NAME=u
set TASK_PAUSE_TIME_IN_MS=%COMMON_PAUSE_TIME_IN_MS%
set TASK_WATCHDOG_IN_SAMPLES=%COMMON_WATCHDOG_IN_SAMPLES%
set TASK_WATCHDOG_THRESHOLD_IN_CPU_UTILIZATION_IN_PERCENT=%COMMON_WATCHDOG_THRESHOLD_IN_CPU_UTILIZATION_IN_PERCENT%
set TASK_WATCHDOG_OPTIONS=--watchdog %TASK_WATCHDOG_IN_SAMPLES% --watchdog_cpu_usage_limit %TASK_WATCHDOG_THRESHOLD_IN_CPU_UTILIZATION_IN_PERCENT%
rem set TASK_WATCHDOG_OPTIONS=
set TASK_TIME_DATA=%COMMON_TIME_DATA%
set TASK_KEY_DATA=%COMMON_KEY_DATA%
set TASK_PERFORMANCE_DATA=%COMMON_PERFORMANCE_DATA%
set TASK_IN_CYCLE_PERFORMANCE_DATA=%COMMON_IN_CYCLE_PERFORMANCE_DATA%
set TASK_ADDRESS_IPV4=%COMMON_ADDRESS_IPV4%
set TASK_XLOADER_LOCK=yes
set TASK_DELAYED_DCTL_IN_MS=%COMMON_DELAYED_DCTL_IN_MS%

rem //-------------------------------------------------------------------------
rem // Installation files settings.
rem //-------------------------------------------------------------------------
set TASK_XML_FILE_NAME=%BIN_FOLDER%\task.xml
set TASK_BATCH_FILE_NAME=%BIN_FOLDER%\task.bat
set TASK_BATCH_FILE_WITHOUT_PATH=task.bat
set TASK_REGISTRY_TASK_FILE_NAME=%SERVICE_RESOLVED_OUTPUTS_FOLDER%\task.reg
set SERVICE_REGISTRY_INSTALL_FILE_NAME=%SERVICE_RESOLVED_OUTPUTS_FOLDER%\install.reg
set INSTALLER_LOG_FILE_NAME=%SERVICE_RESOLVED_OUTPUTS_FOLDER%\installer_log.txt

rem //-------------------------------------------------------------------------
rem // Payloads' settings.
rem //-------------------------------------------------------------------------
rem //-------------------------------------------------------------------------
rem // Service built-in collectors settings.
rem //-------------------------------------------------------------------------
set SERVICE_CONFIG_001=
set SERVICE_CONFIG_002=
set SERVICE_CONFIG_003=
set SERVICE_CONFIG_004=
set SERVICE_CONFIG_005=
set SERVICE_CONFIG_006=
set SERVICE_CONFIG_007=
set SERVICE_CONFIG_008=
set SERVICE_CONFIG_009=
set SERVICE_CONFIG_010=

rem //-------------------------------------------------------------------------
rem // Service input libraries that required configuration.
rem //-------------------------------------------------------------------------
rem //-------------------------------------------------------------------------
rem // OS IL.
rem //    Build schedule files.
rem //-------------------------------------------------------------------------
rem set OS_AUTO_MIN_TICK=15
rem set OS_AUTO_TICK_GAP=5
rem set OS_SCHEDULE_FILE_NAME=sur_os_schedule.txt
rem echo configuration_file=%BIN_FOLDER%\sur_os_counters.txt run_for=720 interval=10 > "%BIN_FOLDER%\%OS_SCHEDULE_FILE_NAME%"
rem echo configuration_file=%BIN_FOLDER%\sur_os_counters_heavy.txt run_for=50 interval=10 >> "%BIN_FOLDER%\%OS_SCHEDULE_FILE_NAME%"

rem //-------------------------------------------------------------------------
rem // Service input libraries' settings.
rem // ATTENTION: few ILs need to stay in the same position (for example UPNP),
rem // otherwise, you must change settings that depend on this order. Again,
rem // for UPNP IL, it is the SERVICE_RUN_UPNP_IL variable.
rem //-------------------------------------------------------------------------
set SERVICE_INPUT_LIBRARY_001=il='!ESCAPED_BIN_FOLDER!\\intel_acpi_battery_input.dll','start_at=!BATTERY_STARTUP_DELAY!'
set SERVICE_INPUT_LIBRARY_002=il='!ESCAPED_BIN_FOLDER!\\intel_wifi_input.dll'
set SERVICE_INPUT_LIBRARY_003=il='!ESCAPED_BIN_FOLDER!\\devices_use_input.dll','service=yes enumerate_pid=yes'
set SERVICE_INPUT_LIBRARY_004=il='!ESCAPED_BIN_FOLDER!\\intel_system_power_state_input.dll','numsamples_to_buffer=!NUMSAMPLES_TO_BUFFER! clock=!SSTATES_CLOCK! delayed_resume=!SSTATES_DELAYED_RESUME_MS!'
set SERVICE_INPUT_LIBRARY_005=il='!ESCAPED_BIN_FOLDER!\\intel_os_input.dll','clock=!COMMON_PAUSE_TIME_IN_MS! threads=auto configuration_file=!ESCAPED_BIN_FOLDER!\\sur_os_counters.txt optimize=yes auto_min_tick=10 auto_tick_gap=5'
set SERVICE_INPUT_LIBRARY_006=il='!ESCAPED_BIN_FOLDER!\\intel_phat_input.dll','delay=1000 always_log_phat_metadata=YES extract_phat_on_new_boot_only=YES'
set SERVICE_INPUT_LIBRARY_007=
set SERVICE_INPUT_LIBRARY_008=il='!ESCAPED_BIN_FOLDER!\\intel_process_input.dll','configuration_file=!ESCAPED_BIN_FOLDER!\\process_input_options.txt'
set SERVICE_INPUT_LIBRARY_009=

rem // !!! SERVICE_INPUT_LIBRARY_010~SERVICE_INPUT_LIBRARY_014 are reserved for ILs that use SEMA driver !!!
set SERVICE_INPUT_LIBRARY_010=
set SERVICE_INPUT_LIBRARY_011=il='!ESCAPED_BIN_FOLDER!\\intel_hw_input.dll','configuration_file=!ESCAPED_BIN_FOLDER!\\sur_hw_config.txt'
set SERVICE_INPUT_LIBRARY_012=
set SERVICE_INPUT_LIBRARY_013=il='!ESCAPED_BIN_FOLDER!\\intel_etw_input.dll','configuration_file=!ESCAPED_BIN_FOLDER!\\etw_options_config.txt'
set SERVICE_INPUT_LIBRARY_014=

set SERVICE_INPUT_LIBRARY_015=il='!ESCAPED_BIN_FOLDER!\\intel_crashlog_input.dll','start_at=!CRASHLOG_STARTUP_DELAY! nogpr_cpusig_count=3 read_sampling_count_max=200 configuration_file=!ESCAPED_BIN_FOLDER!\\crashlog_options.txt '
set SERVICE_INPUT_LIBRARY_016=il='!ESCAPED_BIN_FOLDER!\\intel_pmon_fps_input.dll'
set SERVICE_INPUT_LIBRARY_017=il='!ESCAPED_BIN_FOLDER!\\intel_heartbeat_input.dll','service=yes'
set SERVICE_INPUT_LIBRARY_018=il='!ESCAPED_BIN_FOLDER!\\intel_csme_input.dll','start_at=!CSME_STARTUP_DELAY!'
set SERVICE_INPUT_LIBRARY_019=
set SERVICE_INPUT_LIBRARY_020=il='!ESCAPED_BIN_FOLDER!\\intel_process_watcher_input.dll','override=yes configure=yes generate_samples=yes enumeration=no enumeration_delay=10000 enumeration_pause=250'
set SERVICE_INPUT_LIBRARY_021=

rem //-------------------------------------------------------------------------
rem // Service actuator libraries' settings.
rem //-------------------------------------------------------------------------
set SERVICE_ACTUATOR_LIBRARY_001=
set SERVICE_ACTUATOR_LIBRARY_002=
set SERVICE_ACTUATOR_LIBRARY_003=
set SERVICE_ACTUATOR_LIBRARY_004=
set SERVICE_ACTUATOR_LIBRARY_005=
set SERVICE_ACTUATOR_LIBRARY_006=
set SERVICE_ACTUATOR_LIBRARY_007=
set SERVICE_ACTUATOR_LIBRARY_008=
set SERVICE_ACTUATOR_LIBRARY_009=
set SERVICE_ACTUATOR_LIBRARY_010=

rem //-------------------------------------------------------------------------
rem // Service logger library's settings.
rem //-------------------------------------------------------------------------
set SERVICE_LOGGER_LIBRARY_001=ll='!ESCAPED_BIN_FOLDER!\\sql_logger.dll','db_differential_elaspsed_time=yes db_wal=yes db_wal_autocheckpoint=0 db_cache=yes db_cache_size=auto db_max_page_count=%COMMON_DB_MAX_PAGE_COUNT% db_synchronous=off db_journal_mode=off db_locking_mode=exclusive+ delayed_dctl=summarize dctl_process_delay=%SERVICE_DELAYED_DCTL_IN_MS%'

rem //-------------------------------------------------------------------------
rem // Task built-in collectors settings.
rem //-------------------------------------------------------------------------
set TASK_CONFIG_001=
set TASK_CONFIG_002=
set TASK_CONFIG_003=
set TASK_CONFIG_004=
set TASK_CONFIG_005=
set TASK_CONFIG_006=
set TASK_CONFIG_007=
set TASK_CONFIG_008=
set TASK_CONFIG_009=
set TASK_CONFIG_010=

rem //-------------------------------------------------------------------------
rem // Task input libraries' settings.
rem //-------------------------------------------------------------------------
set TASK_INPUT_LIBRARY_001=il='!ESCAPED_BIN_FOLDER!\\intel_user_waiting_input.dll'
set TASK_INPUT_LIBRARY_002=
set TASK_INPUT_LIBRARY_003=il='!ESCAPED_BIN_FOLDER!\\intel_system_power_state_input.dll','service=no'
set TASK_INPUT_LIBRARY_004=il='!ESCAPED_BIN_FOLDER!\\intel_foreground_window_input.dll','utf8_encoding=yes rdctl_pid=yes rdctl_address=127.0.0.1 rdctl_port=!CUSTOMER_SERVICE_PORT! clock=500 log_all_inputs=yes drive_desktop_mapping=yes drive_desktop_mapping_on_all_clicks=focused use_mouse=yes'
set TASK_INPUT_LIBRARY_005=il='!ESCAPED_BIN_FOLDER!\\intel_heartbeat_input.dll','service=no'
set TASK_INPUT_LIBRARY_006=il='!ESCAPED_BIN_FOLDER!\\intel_desktop_mapper_input.dll','foreground_window_driven=yes clock=no always_get_exe_name_from_pid=yes map_occulted_windows=no detect_dynamic_monitors=yes'
set TASK_INPUT_LIBRARY_007=il='!ESCAPED_BIN_FOLDER!\\intel_display_input.dll','start_at=!DISPLAY_STARTUP_DELAY!'
set TASK_INPUT_LIBRARY_008=
set TASK_INPUT_LIBRARY_009=
set TASK_INPUT_LIBRARY_010=
set TASK_INPUT_LIBRARY_011=
set TASK_INPUT_LIBRARY_012=
set TASK_INPUT_LIBRARY_013=
set TASK_INPUT_LIBRARY_014=
set TASK_INPUT_LIBRARY_015=
set TASK_INPUT_LIBRARY_016=
set TASK_INPUT_LIBRARY_017=
set TASK_INPUT_LIBRARY_018=
set TASK_INPUT_LIBRARY_019=
set TASK_INPUT_LIBRARY_020=

rem //-------------------------------------------------------------------------
rem // Task actuator libraries' settings.
rem //-------------------------------------------------------------------------
set TASK_ACTUATOR_LIBRARY_001=
set TASK_ACTUATOR_LIBRARY_002=
set TASK_ACTUATOR_LIBRARY_003=
set TASK_ACTUATOR_LIBRARY_004=
set TASK_ACTUATOR_LIBRARY_005=
set TASK_ACTUATOR_LIBRARY_006=
set TASK_ACTUATOR_LIBRARY_007=
set TASK_ACTUATOR_LIBRARY_008=
set TASK_ACTUATOR_LIBRARY_009=
set TASK_ACTUATOR_LIBRARY_010=

rem //-------------------------------------------------------------------------
rem // Task logger library's settings.
rem //-------------------------------------------------------------------------
set TASK_LOGGER_LIBRARY_001=ll='!ESCAPED_BIN_FOLDER!\\sql_logger.dll','db_differential_elaspsed_time=yes db_wal=yes db_wal_autocheckpoint=0 db_cache=yes db_cache_size=auto db_max_page_count=%COMMON_DB_MAX_PAGE_COUNT% db_synchronous=off db_journal_mode=off db_locking_mode=exclusive+ delayed_dctl=summarize dctl_process_delay=%TASK_DELAYED_DCTL_IN_MS%'

rem //-------------------------------------------------------------------------
rem // Initialize the log file.
rem //-------------------------------------------------------------------------
if not exist "%SERVICE_RESOLVED_OUTPUTS_FOLDER%" mkdir "%SERVICE_RESOLVED_OUTPUTS_FOLDER%"
echo [%DATE% - %TIME%] >> "%INSTALLER_LOG_FILE_NAME%"
echo [%CD%] >> "%INSTALLER_LOG_FILE_NAME%"

rem //-------------------------------------------------------------------------
rem // Perform basic tests.
rem //-------------------------------------------------------------------------
rem //-------------------------------------------------------------------------
rem // Check if this script is run from where it should be.
rem //-------------------------------------------------------------------------
if not "%CD%"=="%BIN_FOLDER%" (
	echo ERROR: Must be run from [%BIN_FOLDER%]. It is now running from [%CD%]
	goto INSTALLER_EXIT
)

rem //-------------------------------------------------------------------------
rem // By-pass the interactive menu if an argument has been provided.
rem //-------------------------------------------------------------------------
:ENTRY
if "%1" == "" goto MENU
rem //-------------------------------------------------------------------------
rem       000000000
rem       123456789
choice /C ISOUDMXTQ /N /D %1 /T 0
goto GOT_ARGUMENT_FROM_CLI

rem //-------------------------------------------------------------------------
rem // Display options menu.
rem //-------------------------------------------------------------------------
:MENU
cls
@echo " [%DATE% - %TIME%]
@echo " [%CD%]
@echo "+----------------------------------------------------------------------+
@echo "| I: Install the SUR collector.                                        |
@echo "| S: Start the SUR collector (service and task).                       |
@echo "| T: Start the SUR collector (service only).                           |
@echo "| O: Stop the SUR collector.                                           |
@echo "| U: Un-install the SUR collector (does O prior to U).                 |
@echo "| D: Display the settings used during the operations.                  |
@echo "| M: Emit a SUMMARY DCTL to all tasks and service.                     |
@echo "|                                                                      |
@echo "| X: Toggle the installation mode.                                     |
@echo "|                                                                      |
@echo "| Q: Quit.                                                             |
@echo "+----------------------------------------------------------------------+
echo "[WARNING]: MUST be run as Administrator.

rem //-------------------------------------------------------------------------
rem // Display key configuration.
rem //-------------------------------------------------------------------------
echo "CUSTOMER..................:[%CUSTOMER_UC_NAME%].
echo "ID........................:[%CUSTOMER_ID%].
if %INSTALL_DISABLED% == YES (
	echo "INSTALLATION MODE:.........[DISABLED]
) else (
	echo "INSTALLATION MODE:.........[ENABLED]
)

rem //-------------------------------------------------------------------------

rem //-------------------------------------------------------------------------
rem // Process user input.
rem //-------------------------------------------------------------------------
rem       000000000
rem       123456789
choice /C ISOUDMXTQ /N /M "Press the key of your choice:"

:GOT_ARGUMENT_FROM_CLI

if %ERRORLEVEL% == 1 goto INSTALL
if %ERRORLEVEL% == 2 goto START
if %ERRORLEVEL% == 3 (
	set STOP_ONLY=YES
	goto STOP
)
if %ERRORLEVEL% == 4 ( 
	set STOP_ONLY=NO
	goto STOP
)
if %ERRORLEVEL% == 5 goto DISPLAY
if %ERRORLEVEL% == 6 goto SUMMARY
if %ERRORLEVEL% == 7 goto TOGGLE_INSTALL_MODE
if %ERRORLEVEL% == 8 goto START_ONLY_SERVICE
if %ERRORLEVEL% == 9 goto END
if %ERRORLEVEL% GTR 9 goto END

goto END

rem  @@@@@  @@@@   @@@@   @@@@  @      @@@@@@
rem    @   @    @ @    @ @    @ @      @
rem    @   @    @ @      @      @      @
rem    @   @    @ @      @      @      @@@@@@
rem    @   @    @ @  @@@ @  @@@ @      @
rem    @   @    @ @    @ @    @ @      @
rem    @    @@@@   @@@@   @@@@  @@@@@@ @@@@@@
rem //-------------------------------------------------------------------------
rem // Toggle the installation mode. Default is ENBABLED.
rem //-------------------------------------------------------------------------
:TOGGLE_INSTALL_MODE
echo [(T)oggle] >> "%INSTALLER_LOG_FILE_NAME%"
if %INSTALL_DISABLED% == YES (
	set INSTALL_DISABLED=NO
) else (
	set INSTALL_DISABLED=YES
)
shift
goto ENTRY

rem @@@@@  @    @  @@@@   @@@@@   @@   @      @
rem   @    @@   @ @    @    @    @  @  @      @
rem   @    @ @  @ @         @   @    @ @      @
rem   @    @ @  @  @@@@     @   @    @ @      @
rem   @    @  @ @      @    @   @@@@@@ @      @
rem   @    @   @@      @    @   @    @ @      @
rem @@@@@  @    @ @@@@@     @   @    @ @@@@@@ @@@@@@
rem //-------------------------------------------------------------------------
rem // Install the SUR collector.
rem //-------------------------------------------------------------------------
:INSTALL
echo [(I)nstall] >> "%INSTALLER_LOG_FILE_NAME%"

rem //-------------------------------------------------------------------------
rem // If Consented, set HKLM\SOFTWARE\Intel\SUR\ICIP_RUN\Run=1
rem //-------------------------------------------------------------------------
%SystemRoot%\System32\reg.exe query HKLM\SOFTWARE\Intel\SUR\ICIP /v Consent | find "0x1"
if %ERRORLEVEL% == 0 (
	echo %SystemRoot%\System32\reg.exe add HKLM\%START_DEPENDENCY_KEY% /v Run /t REG_DWORD /d 1 /f >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	%SystemRoot%\System32\reg.exe add HKLM\%START_DEPENDENCY_KEY% /v Run /t REG_DWORD /d 1 /f >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
) else (
	echo %SystemRoot%\System32\reg.exe query HKLM\SOFTWARE\Intel\SUR\ICIP /v Consent did not found "0x1" >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	goto END
)

rem //-------------------------------------------------------------------------
rem // Install the esrv service.
rem //-------------------------------------------------------------------------


rem //-------------------------------------------------------------------------
rem // Build the install registry file.
rem //-------------------------------------------------------------------------
echo Windows Registry Editor Version 5.00 > "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
echo( >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
echo [%SERVICE_REGISTRY_KEY%] >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
(echo(|set /p =""install"="--install --install_directory \"!ESCAPED_BIN_FOLDER!\" --output_folder \"%SERVICE_ESCAPED_UPLOAD_FOLDER%\" --depend_on_key %ESCAPED_START_DEPENDENCY_KEY% !SERVICE_DEPENDENCY_OPTIONS! --address %SERVICE_ADDRESS_IPV4% --port %SERVICE_PORT% --do_not_generate_dump_files --time_in_ms --pause %SERVICE_PAUSE_TIME_IN_MS% %SERVICE_WATCHDOG_OPTIONS% --end_on_error --priority_boost --kernel_priority_boost --shutdown_priority_boost --do_not_use_system_error_logs --library \"!ESCAPED_BIN_FOLDER!\\intel_modeler.dll\" --no_pl --resume_delay %COMMON_RESUME_DELAY_IN_MS%  --device_options \" time=%SERVICE_TIME_DATA%  generate_key_file=%SERVICE_KEY_DATA% performance=%SERVICE_PERFORMANCE_DATA% in_cycle_performance=%SERVICE_IN_CYCLE_PERFORMANCE_DATA% output=%SERVICE_OUTPUT_FILE_NAME% output_folder='!SERVICE_ESCAPED_OUTPUTS_FOLDER!' upload_folder='!SERVICE_ESCAPED_UPLOAD_FOLDER!' lock_xls=%SERVICE_XLOADER_LOCK% !COMMON_LOGGER_MODELER_OPTIONS! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
rem //-------------------------------------------------------------------------
if not "%SERVICE_CONFIG_001%"=="" (echo(|set /p ="!SERVICE_CONFIG_001! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_CONFIG_002%"=="" (echo(|set /p ="!SERVICE_CONFIG_002! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_CONFIG_003%"=="" (echo(|set /p ="!SERVICE_CONFIG_003! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_CONFIG_004%"=="" (echo(|set /p ="!SERVICE_CONFIG_004! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_CONFIG_005%"=="" (echo(|set /p ="!SERVICE_CONFIG_005! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_CONFIG_006%"=="" (echo(|set /p ="!SERVICE_CONFIG_006! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_CONFIG_007%"=="" (echo(|set /p ="!SERVICE_CONFIG_007! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_CONFIG_008%"=="" (echo(|set /p ="!SERVICE_CONFIG_008! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_CONFIG_009%"=="" (echo(|set /p ="!SERVICE_CONFIG_009! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_CONFIG_010%"=="" (echo(|set /p ="!SERVICE_CONFIG_010! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
rem //-------------------------------------------------------------------------
if not "%SERVICE_INPUT_LIBRARY_001%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_001! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_002%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_002! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_003%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_003! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_004%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_004! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_005%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_005! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_006%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_006! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_007%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_007! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_008%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_008! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_009%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_009! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_010%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_010! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_011%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_011! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_012%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_012! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_013%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_013! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_014%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_014! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_015%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_015! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_016%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_016! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_017%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_017! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_018%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_018! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_019%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_019! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_020%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_020! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_INPUT_LIBRARY_021%"=="" (echo(|set /p ="!SERVICE_INPUT_LIBRARY_021! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
rem //-------------------------------------------------------------------------
if not "%SERVICE_ACTUATOR_LIBRARY_001%"=="" (echo(|set /p ="!SERVICE_ACTUATOR_LIBRARY_001! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_ACTUATOR_LIBRARY_002%"=="" (echo(|set /p ="!SERVICE_ACTUATOR_LIBRARY_002! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_ACTUATOR_LIBRARY_003%"=="" (echo(|set /p ="!SERVICE_ACTUATOR_LIBRARY_003! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_ACTUATOR_LIBRARY_004%"=="" (echo(|set /p ="!SERVICE_ACTUATOR_LIBRARY_004! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_ACTUATOR_LIBRARY_005%"=="" (echo(|set /p ="!SERVICE_ACTUATOR_LIBRARY_005! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_ACTUATOR_LIBRARY_006%"=="" (echo(|set /p ="!SERVICE_ACTUATOR_LIBRARY_006! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_ACTUATOR_LIBRARY_007%"=="" (echo(|set /p ="!SERVICE_ACTUATOR_LIBRARY_007! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_ACTUATOR_LIBRARY_008%"=="" (echo(|set /p ="!SERVICE_ACTUATOR_LIBRARY_008! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_ACTUATOR_LIBRARY_009%"=="" (echo(|set /p ="!SERVICE_ACTUATOR_LIBRARY_009! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
if not "%SERVICE_ACTUATOR_LIBRARY_010%"=="" (echo(|set /p ="!SERVICE_ACTUATOR_LIBRARY_010! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
rem //-------------------------------------------------------------------------
if not "%SERVICE_LOGGER_LIBRARY_001%"=="" (echo(|set /p ="!SERVICE_LOGGER_LIBRARY_001! ") >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
rem //-------------------------------------------------------------------------
(echo(|set /p ="\""") >> %SERVICE_REGISTRY_INSTALL_FILE_NAME%
echo( >> "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"

rem //-------------------------------------------------------------------------
rem // Import the install registry file.
rem //-------------------------------------------------------------------------
set COMMAND=^
%SystemRoot%\System32\reg.exe^
 import "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)

rem //-------------------------------------------------------------------------
rem // Delete the install registry file.
rem //-------------------------------------------------------------------------
set COMMAND=^
del /f /q "%SERVICE_REGISTRY_INSTALL_FILE_NAME%"
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)

rem //-------------------------------------------------------------------------
rem // Install the esrv service.
rem //-------------------------------------------------------------------------
set COMMAND="%BIN_FOLDER%\esrv_svc.exe"^
 --install^
 --install_options_registry_key %SERVICE_REGISTRY_KEY_INSTALL_VALUE%
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)

rem //-------------------------------------------------------------------------
rem // Install the user esrv service.
rem //-------------------------------------------------------------------------
set COMMAND="%BIN_FOLDER%\esrv_svc.exe"^
 --install^
 --run_as_user_process^
 --install_dir "%BIN_FOLDER%"
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)

rem //-------------------------------------------------------------------------
rem // Remove the install registry value.
rem //-------------------------------------------------------------------------
set COMMAND=^
%SystemRoot%\System32\reg.exe^
 delete %SERVICE_REGISTRY_KEY%^
 /v install^
 /f
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)


rem //-------------------------------------------------------------------------
rem // Install the task.
rem //-------------------------------------------------------------------------
rem //-------------------------------------------------------------------------
rem // Create the task XML file.
rem //-------------------------------------------------------------------------
echo ^<?xml version="1.0" encoding="UTF-16"?^> > "!TASK_XML_FILE_NAME!"
echo ^<Task version="1.2" xmlns="http://schemas.microsoft.com/windows/2004/02/mit/task"^> >> "!TASK_XML_FILE_NAME!"
echo   ^<RegistrationInfo^> >> "!TASK_XML_FILE_NAME!"
echo     ^<Author^>Intel(r) Energy Checker^</Author^> >> "!TASK_XML_FILE_NAME!"
echo   ^</RegistrationInfo^> >> "!TASK_XML_FILE_NAME!"
echo   ^<Triggers^> >> "!TASK_XML_FILE_NAME!"
echo    ^<LogonTrigger^> >> "!TASK_XML_FILE_NAME!"
echo      ^<Repetition^> >> "!TASK_XML_FILE_NAME!"
echo        ^<Interval^>PT3H^</Interval^> >> "!TASK_XML_FILE_NAME!"
echo        ^<StopAtDurationEnd^>false^</StopAtDurationEnd^> >> "!TASK_XML_FILE_NAME!"
echo      ^</Repetition^> >> "!TASK_XML_FILE_NAME!"
echo      ^<Enabled^>true^</Enabled^> >> "!TASK_XML_FILE_NAME!"
echo      ^<Delay^>%TASK_DELAY%^</Delay^> >> "!TASK_XML_FILE_NAME!"
echo    ^</LogonTrigger^> >> "!TASK_XML_FILE_NAME!"
echo   ^</Triggers^> >> "!TASK_XML_FILE_NAME!"
echo   ^<Principals^> >> "!TASK_XML_FILE_NAME!"
echo     ^<Principal id="Author"^> >> "!TASK_XML_FILE_NAME!"
echo       ^<UserId^>NT AUTHORITY\SYSTEM^</UserId^> >> "!TASK_XML_FILE_NAME!"
echo       ^<RunLevel^>HighestAvailable^</RunLevel^> >> "!TASK_XML_FILE_NAME!"
echo     ^</Principal^> >> "!TASK_XML_FILE_NAME!"
echo   ^</Principals^> >> "!TASK_XML_FILE_NAME!"
echo   ^<Settings^> >> "!TASK_XML_FILE_NAME!"
echo     ^<MultipleInstancesPolicy^>IgnoreNew^</MultipleInstancesPolicy^> >> "!TASK_XML_FILE_NAME!"
echo     ^<DisallowStartIfOnBatteries^>false^</DisallowStartIfOnBatteries^> >> "!TASK_XML_FILE_NAME!"
echo     ^<StopIfGoingOnBatteries^>false^</StopIfGoingOnBatteries^> >> "!TASK_XML_FILE_NAME!"
echo     ^<AllowHardTerminate^>true^</AllowHardTerminate^> >> "!TASK_XML_FILE_NAME!"
echo     ^<StartWhenAvailable^>false^</StartWhenAvailable^> >> "!TASK_XML_FILE_NAME!"
echo     ^<RunOnlyIfNetworkAvailable^>false^</RunOnlyIfNetworkAvailable^> >> "!TASK_XML_FILE_NAME!"
echo     ^<IdleSettings^> >> "!TASK_XML_FILE_NAME!"
echo       ^<StopOnIdleEnd^>false^</StopOnIdleEnd^> >> "!TASK_XML_FILE_NAME!"
echo       ^<RestartOnIdle^>false^</RestartOnIdle^> >> "!TASK_XML_FILE_NAME!"
echo     ^</IdleSettings^> >> "!TASK_XML_FILE_NAME!"
echo     ^<AllowStartOnDemand^>true^</AllowStartOnDemand^> >> "!TASK_XML_FILE_NAME!"
echo     ^<Enabled^>true^</Enabled^> >> "!TASK_XML_FILE_NAME!"
echo     ^<Hidden^>false^</Hidden^> >> "!TASK_XML_FILE_NAME!"
echo     ^<RunOnlyIfIdle^>false^</RunOnlyIfIdle^> >> "!TASK_XML_FILE_NAME!"
echo     ^<WakeToRun^>false^</WakeToRun^> >> "!TASK_XML_FILE_NAME!"
echo     ^<ExecutionTimeLimit^>PT3H^</ExecutionTimeLimit^> >> "!TASK_XML_FILE_NAME!"
echo     ^<Priority^>%TASK_PRIORITY%^</Priority^> >> "!TASK_XML_FILE_NAME!"
echo   ^</Settings^> >> "!TASK_XML_FILE_NAME!"
echo   ^<Actions Context="Author"^> >> "!TASK_XML_FILE_NAME!"
echo     ^<Exec^> >> "!TASK_XML_FILE_NAME!"
echo       ^<Command^>powershell^</Command^> >> "!TASK_XML_FILE_NAME!"
echo       ^<Arguments^>-Command "Start-Process -WindowStyle Hidden !TASK_BATCH_FILE_WITHOUT_PATH!"^</Arguments^> >> "!TASK_XML_FILE_NAME!"
echo       ^<WorkingDirectory^>%BIN_FOLDER%^</WorkingDirectory^> >> "!TASK_XML_FILE_NAME!"
echo     ^</Exec^> >> "!TASK_XML_FILE_NAME!"
echo   ^</Actions^> >> "!TASK_XML_FILE_NAME!"
echo ^</Task^> >> "!TASK_XML_FILE_NAME!"


rem //-------------------------------------------------------------------------
rem // Create the task batch file.
rem //-------------------------------------------------------------------------
echo "%BIN_FOLDER%\task.exe" > "!TASK_BATCH_FILE_NAME!"


rem //-------------------------------------------------------------------------
rem // Create the task.
rem //-------------------------------------------------------------------------
set COMMAND=^
%SystemRoot%\System32\schtasks.exe^
 /create^
 /xml "!TASK_XML_FILE_NAME!"^
 /tn !TASK_NAME!
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)

rem //-------------------------------------------------------------------------
rem // Build the task registry file.
rem //-------------------------------------------------------------------------
echo Windows Registry Editor Version 5.00 > "%TASK_REGISTRY_TASK_FILE_NAME%"
echo( >> "%TASK_REGISTRY_TASK_FILE_NAME%"
echo [HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\%USER_SERVICE_NAME%] >> "%TASK_REGISTRY_TASK_FILE_NAME%"
(echo(|set /p =""task"="--start --auto_register_port --output_folder \"%TASK_ESCAPED_UPLOAD_FOLDER%\" --depend_on_key %ESCAPED_START_DEPENDENCY_KEY% !TASK_DEPENDENCY_OPTIONS! --single_instance_only --address %TASK_ADDRESS_IPV4% --port %TASK_START_PORT% --do_not_generate_dump_files --time_in_ms --pause %TASK_PAUSE_TIME_IN_MS% %TASK_WATCHDOG_OPTIONS% --end_on_error --kernel_priority_boost --shutdown_priority_boost --library \"!ESCAPED_BIN_FOLDER!\\intel_modeler.dll\" --no_pl --device_options \" time=%TASK_TIME_DATA% generate_key_file=%TASK_KEY_DATA%  performance=%TASK_PERFORMANCE_DATA% in_cycle_performance=%TASK_IN_CYCLE_PERFORMANCE_DATA% output=%TASK_OUTPUT_FILE_NAME% output_folder='!TASK_ESCAPED_OUTPUTS_FOLDER!' upload_folder='!TASK_ESCAPED_UPLOAD_FOLDER!' lock_xls=%TASK_XLOADER_LOCK% !COMMON_LOGGER_MODELER_OPTIONS! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
rem //-------------------------------------------------------------------------
if not "%TASK_CONFIG_001%"=="" (echo(|set /p ="!TASK_CONFIG_001! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_CONFIG_002%"=="" (echo(|set /p ="!TASK_CONFIG_002! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_CONFIG_003%"=="" (echo(|set /p ="!TASK_CONFIG_003! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_CONFIG_004%"=="" (echo(|set /p ="!TASK_CONFIG_004! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_CONFIG_005%"=="" (echo(|set /p ="!TASK_CONFIG_005! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_CONFIG_006%"=="" (echo(|set /p ="!TASK_CONFIG_006! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_CONFIG_007%"=="" (echo(|set /p ="!TASK_CONFIG_007! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_CONFIG_008%"=="" (echo(|set /p ="!TASK_CONFIG_008! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_CONFIG_009%"=="" (echo(|set /p ="!TASK_CONFIG_009! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_CONFIG_010%"=="" (echo(|set /p ="!TASK_CONFIG_010! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
rem //-------------------------------------------------------------------------
if not "%TASK_INPUT_LIBRARY_001%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_001! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_002%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_002! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_003%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_003! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_004%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_004! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_005%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_005! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_006%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_006! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_007%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_007! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_008%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_008! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_009%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_009! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_010%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_010! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_011%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_011! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_012%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_012! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_013%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_013! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_014%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_014! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_015%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_015! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_016%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_016! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_017%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_017! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_018%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_018! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_019%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_019! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_INPUT_LIBRARY_020%"=="" (echo(|set /p ="!TASK_INPUT_LIBRARY_020! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
rem //-------------------------------------------------------------------------
if not "%TASK_ACTUATOR_LIBRARY_001%"=="" (echo(|set /p ="!TASK_ACTUATOR_LIBRARY_001! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_ACTUATOR_LIBRARY_002%"=="" (echo(|set /p ="!TASK_ACTUATOR_LIBRARY_002! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_ACTUATOR_LIBRARY_003%"=="" (echo(|set /p ="!TASK_ACTUATOR_LIBRARY_003! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_ACTUATOR_LIBRARY_004%"=="" (echo(|set /p ="!TASK_ACTUATOR_LIBRARY_004! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_ACTUATOR_LIBRARY_005%"=="" (echo(|set /p ="!TASK_ACTUATOR_LIBRARY_005! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_ACTUATOR_LIBRARY_006%"=="" (echo(|set /p ="!TASK_ACTUATOR_LIBRARY_006! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_ACTUATOR_LIBRARY_007%"=="" (echo(|set /p ="!TASK_ACTUATOR_LIBRARY_007! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_ACTUATOR_LIBRARY_008%"=="" (echo(|set /p ="!TASK_ACTUATOR_LIBRARY_008! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_ACTUATOR_LIBRARY_009%"=="" (echo(|set /p ="!TASK_ACTUATOR_LIBRARY_009! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
if not "%TASK_ACTUATOR_LIBRARY_010%"=="" (echo(|set /p ="!TASK_ACTUATOR_LIBRARY_010! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
rem //-------------------------------------------------------------------------
if not "%TASK_LOGGER_LIBRARY_001%"=="" (echo(|set /p ="!TASK_LOGGER_LIBRARY_001! ") >> "%TASK_REGISTRY_TASK_FILE_NAME%"
rem //-------------------------------------------------------------------------
(echo(|set /p ="\""") >> %TASK_REGISTRY_TASK_FILE_NAME%
echo( >> "%TASK_REGISTRY_TASK_FILE_NAME%"

rem //-------------------------------------------------------------------------
rem // Import the task value.
rem //-------------------------------------------------------------------------
set COMMAND=^
%SystemRoot%\System32\reg.exe^
 import "%TASK_REGISTRY_TASK_FILE_NAME%"
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)

rem //-------------------------------------------------------------------------
rem // Delete the task registry file.
rem //-------------------------------------------------------------------------
set COMMAND=^
del /f /q "%TASK_REGISTRY_TASK_FILE_NAME%"
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)

if %INSTALL_DISABLED% == YES (

	rem //---------------------------------------------------------------------
	rem // Configure the SERVICEs to on-demand and disable the TASK.
	rem //---------------------------------------------------------------------

	rem //---------------------------------------------------------------------
	rem // Configure the service to on-demand.
	rem //---------------------------------------------------------------------
	set COMMAND=%SystemRoot%\System32\sc.exe config %SERVICE_NAME% start= demand
	if %DEBUG% == YES echo COMMAND=[!COMMAND!] 
	if %EXECUTE% == YES (
		!COMMAND! >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	)
	timeout %TIME_OUT_IN_S%

	rem //---------------------------------------------------------------------
	rem // Configure the user service to on-demand.
	rem //---------------------------------------------------------------------
	set COMMAND=%SystemRoot%\System32\sc.exe config %USER_SERVICE_NAME% start= demand
	if %DEBUG% == YES echo COMMAND=[!COMMAND!] 
	if %EXECUTE% == YES (
		!COMMAND! >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	)
	timeout %TIME_OUT_IN_S%

	rem //---------------------------------------------------------------------
	rem // Disable the scheduled task.
	rem //---------------------------------------------------------------------
	set COMMAND=%SystemRoot%\System32\schtasks.exe /change /tn %TASK_NAME% /DISABLE
	if %DEBUG% == YES echo COMMAND=[!COMMAND!] 
	if %EXECUTE% == YES (
		!COMMAND! >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	)
	timeout %TIME_OUT_IN_S%
)
goto END

rem  @@@@   @@@@@   @@   @@@@@   @@@@@
rem @    @    @    @  @  @    @    @
rem @         @   @    @ @    @    @
rem  @@@@     @   @    @ @@@@@     @
rem      @    @   @@@@@@ @  @      @
rem      @    @   @    @ @   @     @
rem @@@@@     @   @    @ @    @    @
rem //-------------------------------------------------------------------------
rem // Start the SUR collector (service and task).
rem //-------------------------------------------------------------------------
:START
echo [(S)tart] >> "%INSTALLER_LOG_FILE_NAME%"

if %INSTALL_DISABLED% == YES (

	


	rem //---------------------------------------------------------------------
	rem // Configure the ESRV services to auto-start and enable the TASK.
	rem //---------------------------------------------------------------------

	rem //---------------------------------------------------------------------
	rem // Configure the ESRV service to auto-start.
	rem //---------------------------------------------------------------------
	set COMMAND=%SystemRoot%\System32\sc.exe config %SERVICE_NAME% start= delayed-auto
	if %DEBUG% == YES echo COMMAND=[!COMMAND!] 
	if %EXECUTE% == YES (
		!COMMAND! >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	)
	timeout %TIME_OUT_IN_S%

	rem //---------------------------------------------------------------------
	rem // Enable the scheduled task.
	rem //---------------------------------------------------------------------
	set COMMAND=%SystemRoot%\System32\schtasks.exe /change /tn %TASK_NAME% /ENABLE
	if %DEBUG% == YES echo COMMAND=[!COMMAND!] 
	if %EXECUTE% == YES (
		!COMMAND! >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	)
	timeout %TIME_OUT_IN_S%
)

rem // !!! SERVICE_INPUT_LIBRARY_010~SERVICE_INPUT_LIBRARY_014 are reserved for ILs that use SEMA driver !!!
set SEMA_DRIVER_REQUIRED=
if not "%SERVICE_INPUT_LIBRARY_010%"=="" set SEMA_DRIVER_REQUIRED=Yes
if not "%SERVICE_INPUT_LIBRARY_011%"=="" set SEMA_DRIVER_REQUIRED=Yes
if not "%SERVICE_INPUT_LIBRARY_012%"=="" set SEMA_DRIVER_REQUIRED=Yes
if not "%SERVICE_INPUT_LIBRARY_013%"=="" set SEMA_DRIVER_REQUIRED=Yes
if not "%SERVICE_INPUT_LIBRARY_014%"=="" set SEMA_DRIVER_REQUIRED=Yes
if not "%SEMA_DRIVER_REQUIRED%"=="Yes" goto START_ESRV_SERVICE

rem //-------------------------------------------------------------------------
rem // Start SEMA driver service
rem //-------------------------------------------------------------------------
rem //  Stopping SEMA driver service during install time start
	set SERVICE_STOP_COMMAND=%SystemRoot%\System32\net.exe stop %SEMA_DRIVER_SERVICE_NAME% 
	set SEMA_SERVICE_STOP_COMMAND=%SystemRoot%\System32\net.exe stop %SEMA_SERVICE_NAME%
	set SERVICE_START_COMMAND=%SystemRoot%\System32\net.exe start %SEMA_DRIVER_SERVICE_NAME%
	set SEMA_SERVICE_START_COMMAND=%SystemRoot%\System32\net.exe start %SEMA_SERVICE_NAME%
	
	ECHO "Trying to stop SEMA driver service if it is running ..." >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	
	%SystemRoot%\System32\sc.exe queryex %SEMA_DRIVER_SERVICE_NAME% | find "RUNNING" > nul	
	if exist "%SystemRoot%\System32\net.exe" ( if %errorlevel% == 0 ( %SERVICE_STOP_COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1 ) )
	
	%SystemRoot%\System32\sc.exe queryex %SEMA_SERVICE_NAME% | find "RUNNING" > nul	
	if exist "%SystemRoot%\System32\net.exe" ( if %errorlevel% == 0 ( %SEMA_SERVICE_STOP_COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1 ) )
	
rem // COPYING SEMA driver to system32\drivers folder
	ECHO "Copying SEMA driver to %SystemRoot%\System32\drivers\ ..." >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	COPY /Y "!ESCAPED_BIN_FOLDER!\\%SEMA_DRIVER_FILE_NAME%"  %SystemRoot%\System32\drivers\ >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	
	ECHO "Starting SEMA driver ..." >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	
	%SystemRoot%\System32\sc.exe queryex %SEMA_DRIVER_SERVICE_NAME% | find "STOPPED" > nul
	if exist "%SystemRoot%\System32\net.exe" ( if %errorlevel% == 0 ( %SERVICE_START_COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1 ) )	
	
	%SystemRoot%\System32\sc.exe queryex %SEMA_SERVICE_NAME% | find "STOPPED" > nul
	if exist "%SystemRoot%\System32\net.exe" ( if %errorlevel% == 0 ( %SEMA_SERVICE_START_COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1 ) )

:START_ESRV_SERVICE
rem //-------------------------------------------------------------------------
rem // Start the ESRV service.
rem //-------------------------------------------------------------------------
set COMMAND=^
%SystemRoot%\System32\sc.exe^
 start %SERVICE_NAME%
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)

rem //-------------------------------------------------------------------------
rem // Start the TASK.
rem //-------------------------------------------------------------------------
set COMMAND=^
%SystemRoot%\System32\schtasks.exe^
 /run^
 /i^
 /tn %TASK_NAME%
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)
goto END

rem  @@@@   @@@@@   @@   @@@@@   @@@@@     @@@@  @    @  @@@@
rem @    @    @    @  @  @    @    @      @    @ @    @ @    @
rem @         @   @    @ @    @    @      @      @    @ @
rem  @@@@     @   @    @ @@@@@     @       @@@@  @    @ @
rem      @    @   @@@@@@ @  @      @           @  @   @ @
rem      @    @   @    @ @   @     @           @   @ @  @    @
rem @@@@@     @   @    @ @    @    @      @@@@@     @    @@@@
rem //-------------------------------------------------------------------------
rem // Start the SUR collector (service only).
rem //-------------------------------------------------------------------------
:START_ONLY_SERVICE
echo [S(T)art service only] >> "%INSTALLER_LOG_FILE_NAME%"

if %INSTALL_DISABLED% == YES (

	rem //---------------------------------------------------------------------
	rem // Configure the ESRV services to auto-start.
	rem //---------------------------------------------------------------------

	rem //---------------------------------------------------------------------
	rem // Configure the ESRV service to auto-start.
	rem //---------------------------------------------------------------------
	set COMMAND=%SystemRoot%\System32\sc.exe config %SERVICE_NAME% start= delayed-auto
	if %DEBUG% == YES echo COMMAND=[!COMMAND!] 
	if %EXECUTE% == YES (
		!COMMAND! >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	)
	timeout %TIME_OUT_IN_S%
)

rem //-------------------------------------------------------------------------
rem // Start the ESRV service.
rem //-------------------------------------------------------------------------
set COMMAND=^
%SystemRoot%\System32\sc.exe^
 start %SERVICE_NAME%
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)
goto END

rem  @@@@  @    @ @    @ @    @   @@   @@@@@   @  @
rem @    @ @    @ @@  @@ @@  @@  @  @  @    @  @  @
rem @      @    @ @ @@ @ @ @@ @ @    @ @    @  @  @
rem  @@@@  @    @ @    @ @    @ @    @ @@@@@    @
rem      @ @    @ @    @ @    @ @@@@@@ @  @     @
rem      @ @    @ @    @ @    @ @    @ @   @    @
rem @@@@@   @@@@  @    @ @    @ @    @ @    @   @
rem //-------------------------------------------------------------------------
rem // Emit a SUMMARY DCTL to all tasks and service.
rem //-------------------------------------------------------------------------
:SUMMARY
echo [Su(M)mary] >> "%INSTALLER_LOG_FILE_NAME%"

rem //-------------------------------------------------------------------------
rem // Emit a SUMMARY DCTL to the service.
rem //-------------------------------------------------------------------------
set COMMAND="%BIN_FOLDER%\esrv.exe"^
 --device_control SUMMARIZE^
 --address %SERVICE_ADDRESS_IPV4%^
 --port %SERVICE_PORT%
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%]
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)

rem //-------------------------------------------------------------------------
rem // Emit a SUMMARY DCTL to the task(s).
rem //-------------------------------------------------------------------------
for /f "tokens=2*" %%A in ('%SystemRoot%\System32\reg.exe QUERY "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\!USER_SERVICE_NAME!\ports" /t REG_DWORD /f 49* /s 2^>NUL ^| find "REG_DWORD"') do (
	set /a ESRV_INSTANCE_PORT=%%B+0x0
	set COMMAND="%BIN_FOLDER%\esrv.exe" --device_control SUMMARIZE --address !TASK_ADDRESS_IPV4! --port !ESRV_INSTANCE_PORT!
	set /A COMMANDS_COUNT=COMMANDS_COUNT+1
	echo COMMAND[!COMMANDS_COUNT!][%DATE% - %TIME%]=[!COMMAND!] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[!COMMAND!]
	if %EXECUTE% == YES (
		"%BIN_FOLDER%\esrv.exe" --device_control SUMMARIZE --address !TASK_ADDRESS_IPV4! --port !ESRV_INSTANCE_PORT! >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	)
)
goto END

rem  @@@@   @@@@@  @@@@  @@@@@
rem @    @    @   @    @ @    @
rem @         @   @    @ @    @
rem  @@@@     @   @    @ @@@@@
rem      @    @   @    @ @
rem      @    @   @    @ @
rem @@@@@     @    @@@@  @
rem //-------------------------------------------------------------------------
rem // Stop the SUR collector.
rem //-------------------------------------------------------------------------
:STOP
echo [St(O)p] >> "%INSTALLER_LOG_FILE_NAME%"

rem //-------------------------------------------------------------------------
rem // Stop the ESRV service.
rem //-------------------------------------------------------------------------
set COMMAND=^
%SystemRoot%\System32\sc.exe^
 stop %SERVICE_NAME%
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)

rem //-------------------------------------------------------------------------
rem // Note: No action for stopping the transient user ESRV service.
rem //-------------------------------------------------------------------------

rem //-------------------------------------------------------------------------
rem // Stop the task(s).
rem //-------------------------------------------------------------------------
for /f "tokens=2*" %%A in ('%SystemRoot%\System32\reg.exe QUERY "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\!USER_SERVICE_NAME!\ports" /t REG_DWORD /f 49* /s 2^>NUL ^| find "REG_DWORD"') do (
	set /a ESRV_INSTANCE_PORT=%%B+0x0
	set COMMAND="%BIN_FOLDER%\esrv.exe" --stop --port !ESRV_INSTANCE_PORT!
	set /A COMMANDS_COUNT=COMMANDS_COUNT+1
	echo COMMAND[!COMMANDS_COUNT!][%DATE% - %TIME%]=[!COMMAND!] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[!COMMAND!]
	if %EXECUTE% == YES (
		"%BIN_FOLDER%\esrv.exe" --stop --port !ESRV_INSTANCE_PORT! >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	)
)

if %INSTALL_DISABLED% == YES (

	rem //---------------------------------------------------------------------
	rem // Configure the ESRV services to on-demand and disable the TASK.
	rem //---------------------------------------------------------------------

	rem //---------------------------------------------------------------------
	rem // Configure the ESRV service to on-demand.
	rem //---------------------------------------------------------------------
	set COMMAND=%SystemRoot%\System32\sc.exe config %SERVICE_NAME% start= demand
	if %DEBUG% == YES echo COMMAND=[!COMMAND!] 
	if %EXECUTE% == YES (
		!COMMAND! >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	)
	timeout %TIME_OUT_IN_S%

	rem //---------------------------------------------------------------------
	rem // Configure the user ESRV service to on-demand.
	rem //---------------------------------------------------------------------
	set COMMAND=%SystemRoot%\System32\sc.exe config %USER_SERVICE_NAME% start= demand
	if %DEBUG% == YES echo COMMAND=[!COMMAND!] 
	if %EXECUTE% == YES (
		!COMMAND! >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	)
	timeout %TIME_OUT_IN_S%

	rem //---------------------------------------------------------------------
	rem // Disable the scheduled TASK.
	rem //---------------------------------------------------------------------
	set COMMAND=%SystemRoot%\System32\schtasks.exe /change /tn %TASK_NAME% /DISABLE
	if %DEBUG% == YES echo COMMAND=[!COMMAND!] 
	if %EXECUTE% == YES (
		!COMMAND! >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	)
	timeout %TIME_OUT_IN_S%
)

if %STOP_ONLY% == YES goto END

rem @    @ @    @ @@@@@  @    @  @@@@   @@@@@   @@   @      @
rem @    @ @@   @   @    @@   @ @    @    @    @  @  @      @
rem @    @ @ @  @   @    @ @  @ @         @   @    @ @      @
rem @    @ @ @  @   @    @ @  @  @@@@     @   @    @ @      @
rem @    @ @  @ @   @    @  @ @      @    @   @@@@@@ @      @
rem @    @ @   @@   @    @   @@      @    @   @    @ @      @
rem  @@@@  @    @ @@@@@  @    @ @@@@@     @   @    @ @@@@@@ @@@@@@
rem //-------------------------------------------------------------------------
rem // Un-install the SUR collector.
rem //-------------------------------------------------------------------------
:UNINSTALL
echo [(U)ninstall] >> "%INSTALLER_LOG_FILE_NAME%"

rem //-------------------------------------------------------------------------
rem // Un-install the ESRV service.
rem //-------------------------------------------------------------------------
set COMMAND="%BIN_FOLDER%\esrv_svc.exe"^
 --uninstall
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)

rem //-------------------------------------------------------------------------
rem // Un-install the user ESRV service.
rem //-------------------------------------------------------------------------
set COMMAND="%BIN_FOLDER%\esrv_svc.exe"^
 --uninstall^
 --run_as_user_process
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)

rem //-------------------------------------------------------------------------
rem // Delete start dependency consent key (e.g. ICIP_RUN)
rem //-------------------------------------------------------------------------
set COMMAND=%SystemRoot%\System32\reg.exe^
 delete HKLM\%START_DEPENDENCY_KEY%^
 /f
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)

rem //-------------------------------------------------------------------------
rem // Delete the TASK.
rem //-------------------------------------------------------------------------
set COMMAND=^
%SystemRoot%\System32\schtasks.exe^
 /delete^
 /tn !TASK_NAME!^
 /f
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)

rem //-------------------------------------------------------------------------
rem // Delete the TASK associated files.
rem //-------------------------------------------------------------------------
set COMMAND=^
del /f /q "%TASK_XML_FILE_NAME%"
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)

rem //-------------------------------------------------------------------------
set COMMAND=^
del /f /q "%TASK_BATCH_FILE_NAME%"
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)

rem //-------------------------------------------------------------------------
rem // Delete customer's ID keys if any was used or has been left.
rem //-------------------------------------------------------------------------
rem //-------------------------------------------------------------------------
rem // Delete service ID key.
rem //-------------------------------------------------------------------------
set COMMAND=^
%SystemRoot%\System32\reg.exe^
 delete HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\ESRV_SVC^
 /f
set /A COMMANDS_COUNT=COMMANDS_COUNT+1
echo COMMAND[%COMMANDS_COUNT%][%DATE% - %TIME%]=[%COMMAND%] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[%COMMAND%] 
if %EXECUTE% == YES (
	%COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
)

rem //-------------------------------------------------------------------------
rem // Delete tasks' ID keys.
rem //-------------------------------------------------------------------------
set COMMAND='!WINDIR!\System32\reg.exe QUERY "HKEY_USERS"'
if %DEBUG% == YES echo COMMAND[%COMMANDS_COUNT%]=[!COMMAND!]
for /f "delims=" %%u in ('%SystemRoot%\System32\reg.exe QUERY "HKEY_USERS"') do (
	set key_user=%%u
	set COMMAND=%SystemRoot%\System32\reg.exe QUERY !key_user!\Software\ESRV
	set /A COMMANDS_COUNT=COMMANDS_COUNT+1
	echo COMMAND[!COMMANDS_COUNT!][%DATE% - %TIME%]=[!COMMAND!] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	if %DEBUG% == YES echo COMMAND[!COMMANDS_COUNT!]=[!COMMAND!]
	rem //---------------------------------------------------------------------
	for /f "delims=" %%k in ('%SystemRoot%\System32\reg.exe QUERY !key_user!\Software\ESRV\ids 2^> NUL') do (
		set key=%%k
		if !key! == !key_user!\Software\ESRV\ids\!ID! (
			set COMMAND=%SystemRoot%\System32\reg.exe DELETE !key! /f
			set /A COMMANDS_COUNT=COMMANDS_COUNT+1
			echo COMMAND[!COMMANDS_COUNT!][%DATE% - %TIME%]=[!COMMAND!] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
			if %DEBUG% == YES echo COMMAND[!COMMANDS_COUNT!]=[!COMMAND!]
			if %EXECUTE% == YES (
				!WINDIR!\System32\reg.exe DELETE !key! /f >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
			)
		)
	)
)
rem //-------------------------------------------------------------------------
rem // If customer's ID was the last, remove the entire key. This is OK to do.
rem // If there are no other SURs installed, the system is cleaned-up. If there
rem // is/are other SURs installed, it is OK, because consecutive runs will re-
rem // create the key. So no information is lost, and no issues are introduced.
rem //-------------------------------------------------------------------------
set COMMAND='!WINDIR!\System32\reg.exe QUERY "HKEY_USERS"'
if %DEBUG% == YES echo COMMAND[!COMMANDS_COUNT!]=[!COMMAND!]
for /f "delims=" %%u in ('!WINDIR!\System32\reg.exe QUERY "HKEY_USERS"') do (
	set KEY_USER_FOUND=0
	set KEY_USER_IS_EMPTY=1
	set key_user=%%u
	set COMMAND=!WINDIR!\System32\reg.exe QUERY !key_user!\Software\ESRV
	set /A COMMANDS_COUNT=COMMANDS_COUNT+1
	echo COMMAND[!COMMANDS_COUNT!][%DATE% - %TIME%]=[!COMMAND!] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	if %DEBUG% == YES echo COMMAND[!COMMANDS_COUNT!]=[!COMMAND!]
	for /f "delims=" %%x in ('!WINDIR!\System32\reg.exe QUERY !key_user!\Software\ESRV 2^> NUL') do (
		set esrv_key=%%x
		if not !esrv_key! == "" (
			set KEY_USER_FOUND=1
		)
	)
	rem //---------------------------------------------------------------------
	set COMMAND=!WINDIR!\System32\reg.exe QUERY !key_user!\Software\ESRV\ids
	set /A COMMANDS_COUNT=COMMANDS_COUNT+1
	echo COMMAND[!COMMANDS_COUNT!][%DATE% - %TIME%]=[!COMMAND!] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	if %DEBUG% == YES echo COMMAND[!COMMANDS_COUNT!]=[!COMMAND!]
	for /f "delims=" %%k in ('!WINDIR!\System32\reg.exe QUERY !key_user!\Software\ESRV\ids 2^> NUL') do (
		set key=%%k
		if not !key! == "" (
			set KEY_USER_FOUND=1
			set KEY_USER_IS_EMPTY=0
		)
	)
	rem //---------------------------------------------------------------------
	if !KEY_USER_FOUND! == 1 (
		if !KEY_USER_IS_EMPTY! == 1 (
			if %DEBUG% == YES echo USER KEY:[!key_user!\ESRV] is [EMPTY]
			set COMMAND=!WINDIR!\System32\reg.exe DELETE !key_user!\Software\ESRV /f
			set /A COMMANDS_COUNT=COMMANDS_COUNT+1
			echo COMMAND[!COMMANDS_COUNT!][%DATE% - %TIME%]=[!COMMAND!] >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
			if %DEBUG% == YES echo COMMAND[!COMMANDS_COUNT!]=[!COMMAND!]
			!WINDIR!\System32\reg.exe DELETE !key_user!\Software\ESRV /f >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
		) else (
			if %DEBUG% == YES echo USER KEY:[!key_user!\ESRV] is [NOT EMPTY]
		)
	)
	set COMMAND=
)

rem //-------------------------------------------------------------------------
rem // Uninstall SEMA driver service
rem //-------------------------------------------------------------------------
rem //  Stopping SEMA driver service
	ECHO "Stopping SEMA driver service ..." >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	set SERVICE_STOP_COMMAND=%SystemRoot%\System32\net.exe stop %SEMA_DRIVER_SERVICE_NAME% 
	set SEMA_SERVICE_STOP_COMMAND=%SystemRoot%\System32\net.exe stop %SEMA_SERVICE_NAME%

	%SystemRoot%\System32\sc.exe queryex %SEMA_DRIVER_SERVICE_NAME% | find "RUNNING" > nul	
	if exist "%SystemRoot%\System32\net.exe" ( if %errorlevel% == 0 ( %SERVICE_STOP_COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1 ) )
	%SystemRoot%\System32\sc.exe queryex %SEMA_DRIVER_SERVICE_NAME% | find "STOPPED" > nul
	
	%SystemRoot%\System32\sc.exe queryex %SEMA_SERVICE_NAME% | find "RUNNING" > nul	
	if exist "%SystemRoot%\System32\net.exe" ( if %errorlevel% == 0 ( %SEMA_SERVICE_STOP_COMMAND% >> "%INSTALLER_LOG_FILE_NAME%" 2>&1 ) )
	%SystemRoot%\System32\sc.exe queryex %SEMA_SERVICE_NAME% | find "STOPPED" > nul
	
rem // Removing SEMA driver from system32\drivers folder
	ECHO "Deleting %SystemRoot%\System32\drivers\%SEMA_DRIVER_FILE_NAME% ..." >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	DIR "%SystemRoot%\System32\drivers\%SEMA_DRIVER_FILE_NAME%" | find "%SEMA_DRIVER_FILE_NAME%" >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	DEL /f /q "%SystemRoot%\System32\drivers\%SEMA_DRIVER_FILE_NAME%" >> "%INSTALLER_LOG_FILE_NAME%" 2>&1
	if not exist "%SystemRoot%\System32\drivers\%SEMA_DRIVER_FILE_NAME%" ( ECHO "File deleted successfully" >> "%INSTALLER_LOG_FILE_NAME%" 2>&1 )

	
rem @@@@@  @@@@@   @@@@  @@@@@  @        @@    @  @
rem @    @   @    @    @ @    @ @       @  @   @  @
rem @    @   @    @      @    @ @      @    @  @  @
rem @    @   @     @@@@  @@@@@  @      @    @   @
rem @    @   @         @ @      @      @@@@@@   @
rem @    @   @         @ @      @      @    @   @
rem @@@@@  @@@@@  @@@@@  @      @@@@@@ @    @   @
rem //-------------------------------------------------------------------------
rem // Echo the settings used during the operations.
rem //-------------------------------------------------------------------------
:DISPLAY
echo [(D)isplay] >> "%INSTALLER_LOG_FILE_NAME%"
cls

rem //-------------------------------------------------------------------------
rem // Display configurations.
rem //-------------------------------------------------------------------------
echo //-------------------------------------------------------------------------
echo // Debug and execution settings.
echo //-------------------------------------------------------------------------
echo DEBUG:.....................................................................[!DEBUG!]
echo EXECUTE:...................................................................[!EXECUTE!]
echo INSTALL_DISABLED:..........................................................[!INSTALL_DISABLED!]
echo(
echo //-------------------------------------------------------------------------
echo // Customer settings.
echo //-------------------------------------------------------------------------
echo CUSTOMER_UC_NAME:..........................................................[!CUSTOMER_UC_NAME!]
echo CUSTOMER_ID:...............................................................[!CUSTOMER_ID!]
echo(
echo //-------------------------------------------------------------------------
echo // Folders settings.
echo //-------------------------------------------------------------------------
echo BIN_FOLDER:................................................................[!BIN_FOLDER!]
echo SERVICE_RESOLVED_OUTPUTS_FOLDER:...........................................[!SERVICE_RESOLVED_OUTPUTS_FOLDER!]
echo SERVICE_OUTPUTS_FOLDER:....................................................[!SERVICE_OUTPUTS_FOLDER!]
echo TASK_OUTPUTS_FOLDER:.......................................................[!TASK_OUTPUTS_FOLDER!]
echo SERVICE_UPLOAD_FOLDER:.....................................................[!SERVICE_UPLOAD_FOLDER!]
echo TASK_UPLOAD_FOLDER:........................................................[!TASK_UPLOAD_FOLDER!]
echo ESCAPED_BIN_FOLDER:........................................................[!ESCAPED_BIN_FOLDER!]
echo SERVICE_ESCAPED_OUTPUTS_FOLDER:............................................[!SERVICE_ESCAPED_OUTPUTS_FOLDER!]
echo TASK_ESCAPED_OUTPUTS_FOLDER:...............................................[!TASK_ESCAPED_OUTPUTS_FOLDER!]
echo SERVICE_ESCAPED_UPLOAD_FOLDER:.............................................[!SERVICE_ESCAPED_UPLOAD_FOLDER!]
echo TASK_ESCAPED_UPLOAD_FOLDER:................................................[!TASK_ESCAPED_UPLOAD_FOLDER!]
echo SEMA_DRIVER_FILE_NAME:.....................................................[!SEMA_DRIVER_FILE_NAME!]
echo(
echo //-------------------------------------------------------------------------
echo // Services and tasks common settings.
echo //-------------------------------------------------------------------------
echo COMMON_PAUSE_TIME_IN_MS:...................................................[!COMMON_PAUSE_TIME_IN_MS!]
echo COMMON_RESUME_DELAY_IN_MS:.................................................[!COMMON_RESUME_DELAY_IN_MS!]
echo COMMON_WATCHDOG_IN_SAMPLES:................................................[!COMMON_WATCHDOG_IN_SAMPLES!]
echo COMMON_WATCHDOG_THRESHOLD_IN_CPU_UTILIZATION_IN_PERCENT:...................[!COMMON_WATCHDOG_THRESHOLD_IN_CPU_UTILIZATION_IN_PERCENT!]
echo COMMON_TIME_DATA:..........................................................[!COMMON_TIME_DATA!]
echo COMMON_KEY_DATA:...........................................................[!COMMON_KEY_DATA!]
echo COMMON_PERFORMANCE_DATA:...................................................[!COMMON_PERFORMANCE_DATA!]
echo COMMON_IN_CYCLE_PERFORMANCE_DATA:..........................................[!COMMON_IN_CYCLE_PERFORMANCE_DATA!]
echo COMMON_ADDRESS_IPV4:.......................................................[!COMMON_ADDRESS_IPV4!]
echo COMMON_LOGGER_MODELER_OPTIONS:.............................................[!COMMON_LOGGER_MODELER_OPTIONS!]
echo SERVICE_DEPENDENCY_OPTIONS:................................................[!SERVICE_DEPENDENCY_OPTIONS!]
echo TASK_DEPENDENCY_OPTIONS:...................................................[!TASK_DEPENDENCY_OPTIONS!]
echo(
echo //-------------------------------------------------------------------------
echo // Services settings.
echo //-------------------------------------------------------------------------
echo START_DEPENDENCY_KEY:......................................................[!START_DEPENDENCY_KEY!]
echo(
echo //-------------------------------------------------------------------------
echo // Esrv service settings.
echo //-------------------------------------------------------------------------
echo SERVICE_NAME:..............................................................[!SERVICE_NAME!]
echo SERVICE_REGISTRY_KEY:......................................................[!SERVICE_REGISTRY_KEY!]
echo SERVICE_REGISTRY_KEY_INSTALL_VALUE:........................................[!SERVICE_REGISTRY_KEY_INSTALL_VALUE!]
echo SERVICE_PORT:..............................................................[!SERVICE_PORT!]
echo SERVICE_OUTPUT_FILE_NAME:..................................................[!SERVICE_OUTPUT_FILE_NAME!]

echo SERVICE_PAUSE_TIME_IN_MS:..................................................[!SERVICE_PAUSE_TIME_IN_MS!]
echo SERVICE_WATCHDOG_IN_SAMPLES:...............................................[!SERVICE_WATCHDOG_IN_SAMPLES!]
echo SERVICE_WATCHDOG_THRESHOLD_IN_CPU_UTILIZATION_IN_PERCENT:..................[!SERVICE_WATCHDOG_THRESHOLD_IN_CPU_UTILIZATION_IN_PERCENT!]
echo SERVICE_TIME_DATA:.........................................................[!SERVICE_TIME_DATA!]
echo SERVICE_KEY_DATA:..........................................................[!SERVICE_KEY_DATA!]
echo SERVICE_PERFORMANCE_DATA:..................................................[!SERVICE_PERFORMANCE_DATA!]
echo SERVICE_IN_CYCLE_PERFORMANCE_DATA:.........................................[!SERVICE_IN_CYCLE_PERFORMANCE_DATA!]
echo SERVICE_ADDRESS_IPV4:......................................................[!SERVICE_ADDRESS_IPV4!]

echo SERVICE_LIMIT_OUTPUT_BY:...................................................[!SERVICE_LIMIT_OUTPUT_BY!]
echo SERVICE_OUTPUT_LIMIT_IN_MS:................................................[!SERVICE_OUTPUT_LIMIT_IN_MS!]
echo SERVICE_OUTPUT_BUFFER_IN_KB:...............................................[!SERVICE_OUTPUT_BUFFER_IN_KB!]
echo SERVICE_OUTPUT_CACHE_IN_KB:................................................[!SERVICE_OUTPUT_CACHE_IN_KB!]
echo SERVICE_XLOADER_LOCK:......................................................[!SERVICE_XLOADER_LOCK!]
echo(
echo //-------------------------------------------------------------------------
echo // User esrv service settings.
echo //-------------------------------------------------------------------------
echo USER_SERVICE_NAME:.........................................................[!USER_SERVICE_NAME!]
echo(
echo //-------------------------------------------------------------------------
echo // Task settings.
echo //-------------------------------------------------------------------------
echo TASK_NAME:.................................................................[!TASK_NAME!]
echo TASK_DELAY:................................................................[!TASK_DELAY!]
echo TASK_PRIORITY:.............................................................[!TASK_PRIORITY!]
echo TASK_START_PORT:...........................................................[!TASK_START_PORT!]
echo TASK_OUTPUT_FILE_NAME:.....................................................[!TASK_OUTPUT_FILE_NAME!]

echo TASK_PAUSE_TIME_IN_MS:.....................................................[!TASK_PAUSE_TIME_IN_MS!]
echo TASK_WATCHDOG_IN_SAMPLES:..................................................[!TASK_WATCHDOG_IN_SAMPLES!]
echo TASK_WATCHDOG_THRESHOLD_IN_CPU_UTILIZATION_IN_PERCENT:.....................[!TASK_WATCHDOG_THRESHOLD_IN_CPU_UTILIZATION_IN_PERCENT!]
echo TASK_TIME_DATA:............................................................[!TASK_TIME_DATA!]
echo TASK_KEY_DATA:.............................................................[!TASK_KEY_DATA!]
echo TASK_PERFORMANCE_DATA:.....................................................[!TASK_PERFORMANCE_DATA!]
echo TASK_IN_CYCLE_PERFORMANCE_DATA:............................................[!TASK_IN_CYCLE_PERFORMANCE_DATA!]
echo TASK_ADDRESS_IPV4:.........................................................[!TASK_ADDRESS_IPV4!]

echo TASK_LIMIT_OUTPUT_BY:......................................................[!TASK_LIMIT_OUTPUT_BY!]
echo TASK_OUTPUT_LIMIT_IN_MS:...................................................[!TASK_OUTPUT_LIMIT_IN_MS!]
echo TASK_OUTPUT_BUFFER_IN_KB:..................................................[!TASK_OUTPUT_BUFFER_IN_KB!]
echo TASK_OUTPUT_CACHE_IN_KB:...................................................[!TASK_OUTPUT_CACHE_IN_KB!]
echo TASK_XLOADER_LOCK:.........................................................[!TASK_XLOADER_LOCK!]
echo(
echo //-------------------------------------------------------------------------
echo // Installation files settings.
echo //-------------------------------------------------------------------------
echo TASK_XML_FILE_NAME:........................................................[!TASK_XML_FILE_NAME!]
echo TASK_BATCH_FILE_NAME:......................................................[!TASK_BATCH_FILE_NAME!]
echo TASK_REGISTRY_TASK_FILE_NAME:..............................................[!TASK_REGISTRY_TASK_FILE_NAME!]
echo SERVICE_REGISTRY_INSTALL_FILE_NAME:........................................[!SERVICE_REGISTRY_INSTALL_FILE_NAME!]
echo INSTALLER_LOG_FILE_NAME:...................................................[!INSTALLER_LOG_FILE_NAME!]
echo(
echo //-------------------------------------------------------------------------
echo // Payloads settings.
echo //-------------------------------------------------------------------------
echo(
echo //-------------------------------------------------------------------------
echo // Service built-in collectors settings.
echo //-------------------------------------------------------------------------
echo SERVICE_CONFIG_001:........................................................[!SERVICE_CONFIG_001!]
echo SERVICE_CONFIG_002:........................................................[!SERVICE_CONFIG_002!]
echo SERVICE_CONFIG_003:........................................................[!SERVICE_CONFIG_003!]
echo SERVICE_CONFIG_004:........................................................[!SERVICE_CONFIG_004!]
echo SERVICE_CONFIG_005:........................................................[!SERVICE_CONFIG_005!]
echo SERVICE_CONFIG_006:........................................................[!SERVICE_CONFIG_006!]
echo SERVICE_CONFIG_007:........................................................[!SERVICE_CONFIG_007!]
echo SERVICE_CONFIG_008:........................................................[!SERVICE_CONFIG_008!]
echo SERVICE_CONFIG_009:........................................................[!SERVICE_CONFIG_009!]
echo SERVICE_CONFIG_010:........................................................[!SERVICE_CONFIG_010!]
echo(
echo //-------------------------------------------------------------------------
echo // Service input libraries settings.
echo //-------------------------------------------------------------------------
echo SERVICE_INPUT_LIBRARY_001:.................................................[!SERVICE_INPUT_LIBRARY_001!]
echo SERVICE_INPUT_LIBRARY_002:.................................................[!SERVICE_INPUT_LIBRARY_002!]
echo SERVICE_INPUT_LIBRARY_003:.................................................[!SERVICE_INPUT_LIBRARY_003!]
echo SERVICE_INPUT_LIBRARY_004:.................................................[!SERVICE_INPUT_LIBRARY_004!]
echo SERVICE_INPUT_LIBRARY_005:.................................................[!SERVICE_INPUT_LIBRARY_005!]
echo SERVICE_INPUT_LIBRARY_006:.................................................[!SERVICE_INPUT_LIBRARY_006!]
echo SERVICE_INPUT_LIBRARY_007:.................................................[!SERVICE_INPUT_LIBRARY_007!]
echo SERVICE_INPUT_LIBRARY_008:.................................................[!SERVICE_INPUT_LIBRARY_008!]
echo SERVICE_INPUT_LIBRARY_009:.................................................[!SERVICE_INPUT_LIBRARY_009!]
echo SERVICE_INPUT_LIBRARY_010:.................................................[!SERVICE_INPUT_LIBRARY_010!]
echo SERVICE_INPUT_LIBRARY_011:.................................................[!SERVICE_INPUT_LIBRARY_011!]
echo SERVICE_INPUT_LIBRARY_012:.................................................[!SERVICE_INPUT_LIBRARY_012!]
echo SERVICE_INPUT_LIBRARY_013:.................................................[!SERVICE_INPUT_LIBRARY_013!]
echo SERVICE_INPUT_LIBRARY_014:.................................................[!SERVICE_INPUT_LIBRARY_014!]
echo SERVICE_INPUT_LIBRARY_015:.................................................[!SERVICE_INPUT_LIBRARY_015!]
echo SERVICE_INPUT_LIBRARY_016:.................................................[!SERVICE_INPUT_LIBRARY_016!]
echo SERVICE_INPUT_LIBRARY_017:.................................................[!SERVICE_INPUT_LIBRARY_017!]
echo SERVICE_INPUT_LIBRARY_018:.................................................[!SERVICE_INPUT_LIBRARY_018!]
echo SERVICE_INPUT_LIBRARY_019:.................................................[!SERVICE_INPUT_LIBRARY_019!]
echo SERVICE_INPUT_LIBRARY_020:.................................................[!SERVICE_INPUT_LIBRARY_020!]
echo SERVICE_INPUT_LIBRARY_021:.................................................[!SERVICE_INPUT_LIBRARY_021!]
echo(
echo //-------------------------------------------------------------------------
echo // Service actuator libraries settings.
echo //-------------------------------------------------------------------------
echo SERVICE_ACTUATOR_LIBRARY_001:..............................................[!SERVICE_ACTUATOR_LIBRARY_001!]
echo SERVICE_ACTUATOR_LIBRARY_002:..............................................[!SERVICE_ACTUATOR_LIBRARY_002!]
echo SERVICE_ACTUATOR_LIBRARY_003:..............................................[!SERVICE_ACTUATOR_LIBRARY_003!]
echo SERVICE_ACTUATOR_LIBRARY_004:..............................................[!SERVICE_ACTUATOR_LIBRARY_004!]
echo SERVICE_ACTUATOR_LIBRARY_005:..............................................[!SERVICE_ACTUATOR_LIBRARY_005!]
echo SERVICE_ACTUATOR_LIBRARY_006:..............................................[!SERVICE_ACTUATOR_LIBRARY_006!]
echo SERVICE_ACTUATOR_LIBRARY_007:..............................................[!SERVICE_ACTUATOR_LIBRARY_007!]
echo SERVICE_ACTUATOR_LIBRARY_008:..............................................[!SERVICE_ACTUATOR_LIBRARY_008!]
echo SERVICE_ACTUATOR_LIBRARY_009:..............................................[!SERVICE_ACTUATOR_LIBRARY_009!]
echo SERVICE_ACTUATOR_LIBRARY_010:..............................................[!SERVICE_ACTUATOR_LIBRARY_010!]
echo(
echo //-------------------------------------------------------------------------
echo // Service logger library settings.
echo //-------------------------------------------------------------------------
echo SERVICE_LOGGER_LIBRARY_001:................................................[!SERVICE_LOGGER_LIBRARY_001!]
echo(
echo //-------------------------------------------------------------------------
echo // Task built-in collectors settings.
echo //-------------------------------------------------------------------------
echo TASK_CONFIG_001:...........................................................[!TASK_CONFIG_001!]
echo TASK_CONFIG_002:...........................................................[!TASK_CONFIG_002!]
echo TASK_CONFIG_003:...........................................................[!TASK_CONFIG_003!]
echo TASK_CONFIG_004:...........................................................[!TASK_CONFIG_004!]
echo TASK_CONFIG_005:...........................................................[!TASK_CONFIG_005!]
echo TASK_CONFIG_006:...........................................................[!TASK_CONFIG_006!]
echo TASK_CONFIG_007:...........................................................[!TASK_CONFIG_007!]
echo TASK_CONFIG_008:...........................................................[!TASK_CONFIG_008!]
echo TASK_CONFIG_009:...........................................................[!TASK_CONFIG_009!]
echo TASK_CONFIG_010:...........................................................[!TASK_CONFIG_010!]
echo(
echo //-------------------------------------------------------------------------
echo // Task input libraries settings.
echo //-------------------------------------------------------------------------
echo TASK_INPUT_LIBRARY_001:....................................................[!TASK_INPUT_LIBRARY_001!]
echo TASK_INPUT_LIBRARY_002:....................................................[!TASK_INPUT_LIBRARY_002!]
echo TASK_INPUT_LIBRARY_003:....................................................[!TASK_INPUT_LIBRARY_003!]
echo TASK_INPUT_LIBRARY_004:....................................................[!TASK_INPUT_LIBRARY_004!]
echo TASK_INPUT_LIBRARY_005:....................................................[!TASK_INPUT_LIBRARY_005!]
echo TASK_INPUT_LIBRARY_006:....................................................[!TASK_INPUT_LIBRARY_006!]
echo TASK_INPUT_LIBRARY_007:....................................................[!TASK_INPUT_LIBRARY_007!]
echo TASK_INPUT_LIBRARY_008:....................................................[!TASK_INPUT_LIBRARY_008!]
echo TASK_INPUT_LIBRARY_009:....................................................[!TASK_INPUT_LIBRARY_009!]
echo TASK_INPUT_LIBRARY_010:....................................................[!TASK_INPUT_LIBRARY_010!]
echo TASK_INPUT_LIBRARY_011:....................................................[!TASK_INPUT_LIBRARY_011!]
echo TASK_INPUT_LIBRARY_012:....................................................[!TASK_INPUT_LIBRARY_012!]
echo TASK_INPUT_LIBRARY_013:....................................................[!TASK_INPUT_LIBRARY_013!]
echo TASK_INPUT_LIBRARY_014:....................................................[!TASK_INPUT_LIBRARY_014!]
echo TASK_INPUT_LIBRARY_015:....................................................[!TASK_INPUT_LIBRARY_015!]
echo TASK_INPUT_LIBRARY_016:....................................................[!TASK_INPUT_LIBRARY_016!]
echo TASK_INPUT_LIBRARY_017:....................................................[!TASK_INPUT_LIBRARY_017!]
echo TASK_INPUT_LIBRARY_018:....................................................[!TASK_INPUT_LIBRARY_018!]
echo TASK_INPUT_LIBRARY_019:....................................................[!TASK_INPUT_LIBRARY_019!]
echo TASK_INPUT_LIBRARY_020:....................................................[!TASK_INPUT_LIBRARY_020!]
echo(
echo //-------------------------------------------------------------------------
echo // Task actuator libraries settings.
echo //-------------------------------------------------------------------------
echo TASK_ACTUATOR_LIBRARY_001:.................................................[!TASK_ACTUATOR_LIBRARY_001!]
echo TASK_ACTUATOR_LIBRARY_002:.................................................[!TASK_ACTUATOR_LIBRARY_002!]
echo TASK_ACTUATOR_LIBRARY_003:.................................................[!TASK_ACTUATOR_LIBRARY_003!]
echo TASK_ACTUATOR_LIBRARY_004:.................................................[!TASK_ACTUATOR_LIBRARY_004!]
echo TASK_ACTUATOR_LIBRARY_005:.................................................[!TASK_ACTUATOR_LIBRARY_005!]
echo TASK_ACTUATOR_LIBRARY_006:.................................................[!TASK_ACTUATOR_LIBRARY_006!]
echo TASK_ACTUATOR_LIBRARY_007:.................................................[!TASK_ACTUATOR_LIBRARY_007!]
echo TASK_ACTUATOR_LIBRARY_008:.................................................[!TASK_ACTUATOR_LIBRARY_008!]
echo TASK_ACTUATOR_LIBRARY_009:.................................................[!TASK_ACTUATOR_LIBRARY_009!]
echo TASK_ACTUATOR_LIBRARY_010:.................................................[!TASK_ACTUATOR_LIBRARY_010!]
echo(
echo //-------------------------------------------------------------------------
echo // Task logger library settings.
echo //-------------------------------------------------------------------------
echo TASK_LOGGER_LIBRARY_001:...................................................[!TASK_LOGGER_LIBRARY_001!]
echo(
goto END

rem //-------------------------------------------------------------------------
rem // Branch / end hub.
rem //-------------------------------------------------------------------------
:END
if %ERRORLEVEL% == 9 goto INSTALLER_EXIT
if not "%1"=="" goto INSTALLER_EXIT
pause
goto MENU

:INSTALLER_EXIT
echo [Q] >> "%INSTALLER_LOG_FILE_NAME%"
@echo on
