                
DefinitionBlock("SSDT.AML", "SSDT", 0x01, "AAEON", "PINCTRL", 0x00000001)
{
    External (\_SB_.PCI0.I2C1, DeviceObj)
    Scope(\_SB_.PCI0.I2C1)
    {
		Device(SAR)
		{
		    Name(_HID, "AWDZ9610X")
		    Name(_CID, "AWDZ9610X")
    		    Name(_UID, 1)

		    Method(_CRS, 0x0, NotSerialized)
		    {
		        Name (RBUF, ResourceTemplate () 
		        {
					I2CSerialBusV2(0x12, DeviceInitiated, 400000, AddressingMode7Bit, "\\_SB.PCI0.I2C1", 0, ResourceConsumer, I2C1, Exclusive, )
					GpioInt(Edge, ActiveBoth, Exclusive, PullUp, , "\\_SB.GPO0") {0x2a}
		        })
		        Return(RBUF)
		    }
		    Method(_STA, 0x0, NotSerialized)
           	{
            		Return(0xf)
           	}
		    Method(_DSM, 0x4, Serialized)
			{
				If(LEqual(Arg0,ToUUID("7b9c9aea-ab7b-8c46-84fa-a9a59f8ad1cb")))
				{
					If(LEqual(Arg2, 0x2))
					{
						Return (Buffer() {
								0x74, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
								0x01, 0x00, 0x00, 0x00, 0x40, 0x03, 0x00, 0x00, 0x00, 0x0C, 0x02, 0x00,
								0x41, 0x57, 0x39, 0x36, 0x31, 0x30, 0x35, 0x00, 0x02, 0x00, 0x00, 0x00,
								0x04, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
								0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x00, 0x00, 0x04, 0x00,
								0x14, 0x00, 0x00, 0x00, 0x08, 0x00, 0x1E, 0xC1, 0x17, 0x00, 0x0C, 0x00,
								0x00, 0x00, 0x00, 0x05, 0x10, 0x00, 0xFD, 0x3F, 0x06, 0x00, 0x14, 0x00,
								0x09, 0x00, 0x24, 0x19, 0x18, 0x00, 0x07, 0x02, 0x1C, 0xD8, 0x1C, 0x00,
								0x00, 0x00, 0x00, 0xFF, 0x20, 0x00, 0x00, 0x19, 0x24, 0x00, 0x24, 0x00,
								0xF7, 0x3F, 0x06, 0x00, 0x28, 0x00, 0x09, 0x00, 0x02, 0x58, 0x2C, 0x00,
								0x07, 0x02, 0x1C, 0xD8, 0x30, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x34, 0x00,
								0x00, 0x58, 0x02, 0x00, 0x38, 0x00, 0xDF, 0x3F, 0x06, 0x00, 0x3C, 0x00,
								0x09, 0x00, 0x3B, 0x7D, 0x40, 0x00, 0x07, 0x02, 0x1C, 0xD8, 0x44, 0x00,
								0x00, 0x00, 0x00, 0xFF, 0x48, 0x00, 0x00, 0x7D, 0x3B, 0x00, 0x4C, 0x00,
								0x7F, 0x3F, 0x06, 0x00, 0x50, 0x00, 0x09, 0x00, 0x31, 0xE9, 0x54, 0x00,
								0x07, 0x02, 0x1C, 0xD8, 0x58, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x5C, 0x00,
								0x00, 0xE9, 0x31, 0x00, 0x60, 0x00, 0xFF, 0x3D, 0x06, 0x00, 0x64, 0x00,
								0x09, 0x00, 0x0C, 0x1A, 0x68, 0x00, 0x07, 0x02, 0x1C, 0xD8, 0x6C, 0x00,
								0x00, 0x00, 0x00, 0xFF, 0x70, 0x00, 0x00, 0x1A, 0x0C, 0x00, 0x74, 0x00,
								0xFF, 0x3F, 0x06, 0x80, 0x78, 0x00, 0x09, 0x00, 0x3D, 0x04, 0x7C, 0x00,
								0x07, 0x02, 0x1C, 0xD8, 0x80, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x84, 0x00,
								0x00, 0x04, 0x3D, 0x00, 0xA0, 0x00, 0x00, 0x00, 0x40, 0xE4, 0xA4, 0x00,
								0x00, 0x00, 0x00, 0x00, 0xA8, 0x00, 0xD2, 0x08, 0x00, 0x00, 0xAC, 0x00,
								0x00, 0x00, 0x00, 0x00, 0xB0, 0x00, 0x00, 0x15, 0x00, 0x00, 0xB8, 0x00,
								0xFF, 0x5F, 0x00, 0x00, 0xBC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00,
								0x00, 0x00, 0x00, 0x00, 0xC4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC8, 0x00,
								0x00, 0x00, 0x00, 0x00, 0xCC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD0, 0x00,
								0x00, 0x00, 0x00, 0x00, 0xD4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0x00,
								0x00, 0x00, 0x00, 0x00, 0xDC, 0x00, 0x00, 0x00, 0x40, 0xE4, 0xE0, 0x00,
								0x00, 0x00, 0x00, 0x00, 0xE4, 0x00, 0xD2, 0x08, 0x00, 0x00, 0xE8, 0x00,
								0x00, 0x00, 0x00, 0x00, 0xEC, 0x00, 0x00, 0x15, 0x00, 0x00, 0xF4, 0x00,
								0xFF, 0x5F, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00,
								0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x04, 0x01,
								0x00, 0x00, 0x00, 0x00, 0x08, 0x01, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x01,
								0x00, 0x00, 0x00, 0x00, 0x10, 0x01, 0x00, 0x00, 0x00, 0x00, 0x14, 0x01,
								0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x00, 0x00, 0x40, 0xE4, 0x1C, 0x01,
								0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0xD2, 0x08, 0x00, 0x00, 0x24, 0x01,
								0x00, 0x00, 0x00, 0x00, 0x28, 0x01, 0x00, 0x15, 0x00, 0x00, 0x30, 0x01,
								0xFF, 0x5F, 0x00, 0x00, 0x34, 0x01, 0x00, 0x00, 0x00, 0x00, 0x38, 0x01,
								0x00, 0x00, 0x00, 0x00, 0x3C, 0x01, 0x00, 0x00, 0x00, 0x00, 0x40, 0x01,
								0x00, 0x00, 0x00, 0x00, 0x44, 0x01, 0x00, 0x00, 0x00, 0x00, 0x48, 0x01,
								0x00, 0x00, 0x00, 0x00, 0x4C, 0x01, 0x00, 0x00, 0x00, 0x00, 0x50, 0x01,
								0x00, 0x00, 0x00, 0x00, 0x54, 0x01, 0x00, 0x00, 0x40, 0xE4, 0x58, 0x01,
								0x00, 0x00, 0x00, 0x00, 0x5C, 0x01, 0xD2, 0x08, 0x00, 0x00, 0x60, 0x01,
								0x00, 0x00, 0x00, 0x00, 0x64, 0x01, 0x00, 0x15, 0x00, 0x00, 0x6C, 0x01,
								0xFF, 0x5F, 0x00, 0x00, 0x70, 0x01, 0x00, 0x00, 0x00, 0x00, 0x74, 0x01,
								0x00, 0x00, 0x00, 0x00, 0x78, 0x01, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x01,
								0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x84, 0x01,
								0x00, 0x00, 0x00, 0x00, 0x88, 0x01, 0x00, 0x00, 0x00, 0x00, 0x8C, 0x01,
								0x00, 0x00, 0x00, 0x00, 0x90, 0x01, 0x00, 0x00, 0x40, 0xE4, 0x94, 0x01,
								0x00, 0x00, 0x00, 0x00, 0x98, 0x01, 0xD2, 0x08, 0x00, 0x00, 0x9C, 0x01,
								0x00, 0x00, 0x00, 0x00, 0xA0, 0x01, 0x00, 0x15, 0x00, 0x00, 0xA8, 0x01,
								0xFF, 0x5F, 0x00, 0x00, 0xAC, 0x01, 0x00, 0x00, 0x00, 0x00, 0xB0, 0x01,
								0x00, 0x00, 0x00, 0x00, 0xB4, 0x01, 0x00, 0x00, 0x00, 0x00, 0xB8, 0x01,
								0x00, 0x00, 0x00, 0x00, 0xBC, 0x01, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x01,
								0x00, 0x00, 0x00, 0x00, 0xC4, 0x01, 0x00, 0x00, 0x00, 0x00, 0xC8, 0x01,
								0x00, 0x00, 0x00, 0x00, 0xCC, 0x01, 0x00, 0x00, 0x40, 0xE4, 0xD0, 0x01,
								0x00, 0x00, 0x00, 0x00, 0xD4, 0x01, 0xD2, 0x08, 0x00, 0x00, 0xD8, 0x01,
								0x00, 0x00, 0x00, 0x00, 0xDC, 0x01, 0x00, 0x15, 0x00, 0x00, 0xE4, 0x01,
								0xFF, 0x5F, 0x00, 0x00, 0xE8, 0x01, 0x00, 0x00, 0x00, 0x00, 0xEC, 0x01,
								0x00, 0x00, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x00, 0x00, 0xF4, 0x01,
								0x00, 0x00, 0x00, 0x00, 0xF8, 0x01, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x01,
								0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02,
								0x00, 0x00, 0x00, 0x00, 0x08, 0x02, 0x08, 0x00, 0x00, 0x00, 0x0C, 0x02,
								0x0D, 0x00, 0x00, 0x00, 0xFC, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44,
								0x00, 0x00, 0x00, 0x00, 0x10, 0x44, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44,
								0x00, 0x00, 0x00, 0x00, 0x30, 0x44, 0x00, 0x00, 0x00, 0x00, 0x40, 0x44,
								0x00, 0x00, 0x00, 0x00, 0x50, 0x44, 0x00, 0x00, 0x00, 0x00, 0x60, 0x44,
								0x00, 0x00, 0x00, 0x00, 0x70, 0x44, 0x00, 0x00, 0x00, 0x00, 0x84, 0xF0,
								0x06, 0x02, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x04, 0xF8,
								0x00, 0x2E, 0x00, 0x00, 0x00, 0xFF, 0x01, 0x03, 0x00, 0x00, 0x0C, 0xFF,
								0x00, 0x00, 0x00, 0x01, 0xE0, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF4, 0xFF,
								0x11, 0x40, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x9C, 0x00,
								0x3F, 0x3F, 0x3F, 0x3F})
					}
					If(LEqual(Arg2, 0x3))
					{
						Return (Buffer() {0x03, 0x04, 0x05})
					}
					If(LEqual(Arg2, 0x4))
					{
						If(LEqual(Arg3, Buffer(0x10)
						{
							0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
							0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f						
						}))
						{
							Return (Buffer() {0x06, 0x07, 0x08})
						}
						Else
						{
							Return (Buffer() {0x00, 0x00, 0x00})
						}
					}
					Else
					{
						Return (Buffer() {0x00, 0x00, 0x01})
					}				
				}
				Else
				{
					Return (Buffer() {0x00, 0x00, 0x02})
				}

			}
		}
     }
}
