/*++

Copyright (c) 2012 CognitiveTPG

Module Name:

	cognitiveTPG_BIDI.h

Abstract:

	Function declaration for CognitiveTPG Language Monitor (clmon.dll)

Author:

	D. Tillotson

Revision History:
	2001/08/12 cchang revised for A795

--*/

#ifndef _CognitiveTPG_H
#define _CognitiveTPG_H

#ifdef __cplusplus
extern "C" {
#endif
    
//
// defines
//


typedef enum {
    CLMON_INVALID = 0,
    CLMON_GET_PAPER_SENSOR_STATUS = 1,
    CLMON_GET_CASH_DRAWER_STATUS = 2,
    CLMON_READ_MICR = 3,
    CLMON_PRINT_TEST = 4,
    CLMON_PRINTER_INITIALIZE = 5,
    CLMON_PRINT_MSG = 6,
    CLMON_PRINTER_READ = 7,
    CLMON_UNKNOWN
}CLMONCMD;



BOOL
WINAPI
CLMON_SendRecv (
    IN                        LPWSTR  printerName, //Printer model name. i.e. A799
    IN                        LPWSTR  portName,    //The port name. i.e. USB001, Com1, etc.
    IN                        DWORD   CommandId,   //From the enum
    IN                        LPSTR   lpInBuffer,  //Max len 1024
    IN                        DWORD   cbInBuffer,  //Length of msg in lpInBuffer. Max len 1024
    OUT                       LPSTR   lpOutBuffer,
    IN                        DWORD   cbOutBuffer,
    OUT                       LPDWORD lpcbReturned
);


#ifdef __cplusplus
}
#endif

#endif /* _CognitiveTPG_H */
