@echo off

SET CMDERR=0

start /b /wait .\LenovoCheckRunAsAdmin.exe

if %errorlevel% neq 0 (
  echo Error: This install requires administrator priviledge. 
  pause
  goto end
)

start /b /wait .\LenovoAICCSupportCheck.exe
if %ERRORLEVEL%==1 goto CheckAICCPAlreadyInstalled

SET CMDERR=1
 echo Adaptive ICC Profile is not supported by the system.

reg query HKLM\SYSTEM\CurrentControlSet\Services\LenovoAICCLoader
if %errorlevel% neq 0 (
  echo Adaptive ICC Profile is not found as installed. 
  goto end
)

echo Panel ID change detected 
SCHTASKS /Delete /TN "\Lenovo\AICC\LAICCUserAgent" /f
SCHTASKS /Delete /TN "\Lenovo\AICC\ReApplyHandler" /f
SCHTASKS /Delete /TN "\Lenovo\AICC\UninstallTask" /f
SCHTASKS /Delete /TN "\Lenovo\AICC" /f
sc delete LenovoAICCLoader

goto end

:CheckAICCPAlreadyInstalled
echo Check ICC Adaptive ICC Profile already installed and supported.
start /b /wait .\AICCPInstallPackage\LenovoAICCPCheckInstallState.exe /verify
if %ERRORLEVEL%==0 goto AICCPanelReplaceHandler
goto InstallAICCP

:AICCPanelReplaceHandler
echo Check Display Replaced or not and re-apply profile if needed.
start /b /wait .\PanelReplaceHandler\LenovoAICCPanelReplaceHandler.exe
if %ERRORLEVEL%==0 goto end
echo Install AICCP.
goto InstallAICCP

:InstallAICCP
echo Install Adaptive ICC Profile 
start /b /wait pnputil.exe /add-driver "%~dp0\AICCPInstallPackage\lenovoaiccprofile.inf" /install
start /b /wait .\AICCPInstallPackage\LenovoAICCPCheckInstallState.exe /installstate
SET CMDERR= %ERRORLEVEL%
:end
exit /b %CMDERR%