'use strict';
angular.module('main.config', [])
    .constant('GFECLIENT_CONFIG', {
        "userAgent": "NVIDIAGFEClient",
        "windowName": "gfeclient",
        "mode": "prod",
        "perfmonOCTool": true,
        "jarvis": {
            "server": "https://accounts.nvgs.nvidia.com",
            "serverChina": "https://accounts.nvgs.nvidia.cn",
            "version": "1",
            "deviceId": "gfeclient",
            "clientId": "135333107684344109",
            "commonClientId": "102009640608333825",
            "cevoClientId": "165235150188183768",
            "gfnClientId": "156448804920361176",
            "nvidiaWebClientId": "94211547528691713",
            "clientDescription": "GFE {VERSION}",
            "redirectUrl": "https://rds-assets.nvidia.com/main/redirect/gfe-redirect.html#",
            "redirectUrlJarvisOauth": "http://localhost:{portNumber}",
            "portNumbers": [32425, 31415, 33435, 34415, 64571],
            "onCompleteRedirectUrl": "",
            "redirectParams": ["error"],
            "defaultTimeout": 15000,
            "defaultTimeBetweenRetries": 500,
            "clientCapabilities": ["OAuthPortal"]
        },
        "gfwsl": {
            "server": "https://gfwsl.geforce.com/",
            "serverChina": "https://gfwsl.geforce.cn/",
            "defaultTimeout": 30000,
            "postMethodTimeout": 60000
        },
        "gfservices": {
            "server": "https://services.gfe.nvidia.com/GFE/",
            "version": "v1.0"
        },
        "imageFormatService": {
            "server": "https://img.nvidiagrid.net/"
        },
        "jsEvents": {
            "server": "https://events.gfe.nvidia.com",
            "version": "v1.0",
            "schemaVersion": "6.2",
            "defaultRetries": 2,
            "defaultTimeBetweenRetries": 1000,
            "defaultTimeout": 30000,
            "msBetweenSendRequest": 5000,
            "maxEventsPerRequest": 128
        },
        "cms": {
            "server": "https://static.nvidiagrid.net/",
            "defaultRetries": 2
        },
        "nodeService": {
            "reconnection": true,
            "reconnectionDelay": 1000,
            "reconnectionDelayMax": 1000,
            "reconnectionAttempts": 20
        },
        "rds": {
            "clientId": "b7e85bb1-afe6-4867-b11f-a32a58b7f797",
            "portalRealm": "831c3b05-4aee-4060-998f-e67cc375c35f"
        },
        "anselFeature": true,
        "anselFeatureExperimental": false,
        "parllayConfig": {
            "env": "pro",
            "fhtToken": "AqJLydSIPI"
        },
        "survey": {
            "server": "https://api.gfe.nvidia.com/Survey/surveyengine/",
            "clientType": "gfe"
        },
        "cevo": {
            "server": "https://api.commune.ly/"
        },
        "aem": {
            "server": "https://www.nvidia.com/"
        },
        "feedback": {
            "server": "https://api.gfe.nvidia.com/Survey/feedbackengine/",
            "surveyId": "4b57d5dc-923d-4287-9b71-244eee8e30de",
            "clientType": "gfe",
            "version": "v.0.1"
        },
        "tracerFeature": true,
        "tracer": {
            "access_token": "bb9b4983d436567559f92bb300e1103a",
            "component_name": "Gfe_Client",
            "collector_host": "ls.dtrace.nvidia.com",
            "collector_port": 443,
            "disable_clock_skew_correction": true
        },
        "vrs": {
            "server": "https://www.nvidia.com"
        },
        "geo": {
            "server": "https://api.gfe.nvidia.com/geo/",
            "version": "v1",
            "defaultTimeout": 30000
        },
        "gfnCloudGames": {
            "server": "https://gfn.nvidia.com",
            "version": 1,
            "defaultTimeout": 30000
        },
        "gxtarget": {
            "server": "https://api.gfe.nvidia.com/gxtarget/",
            "version": "v2",
            "defaultTimeout": 30000,
            "gxTargetJarvisClientId": "135333107684344109",
            "platform": "Win"
        }
    })
    .constant('GFECLIENT_BUILD_INFO', {
        "gfePackageVersion": "3.24.0.135",
        "branch": "rel_03_24",
        "branchType": "rel",
        "gfeclientVersion": "0.1.0",
        "gitHash": "2587a0a8b4",
        "buildType": "prod"
    });