@echo off
:: Change directory to script location
pushd "%~dp0"

echo current directory: %CD%
SET CMDERR=0
SET jg_path_to_log_file=.\install-lvd.log

:: Verify admin
NET SESSION >nul 2>&1
IF %ERRORLEVEL% NEQ 0 (
   SET CMDERR=%errorlevel%
   GOTO install_lvd_error_admin
)

:: Check that RTP tag exists
echo Checking RTP tag...
IF EXIST C:\SWWORK\1701.tag (
   echo RTP Tag found: Skipping Lenovo View Installation
   echo "RTP Tag found: Skipping Lenovo View Installation" >> %jg_path_to_log_file%
   GOTO install_lvd_end
)

:install_lvd
ECHO Install Lenovo View Driver
%SystemRoot%\System32\PnPutil.exe -i -a LnvVsnDmft.inf

goto install_lvd_complete

:install_lvd_error_admin
echo Error: This script requires admin
echo "Error: This install requires admin" >> %jg_path_to_log_file%
GOTO install_lvd_end

:install_lvd_complete
SET CMDERR=0
echo Lenovo View Driver installation complete 

:install_lvd_end
popd
exit /b %CMDERR%