CONTAINER Ocacollisiondeformer
{
	NAME Ocacollisiondeformer;
	INCLUDE Obase;
	
	GROUP ID_OBJECTPROPERTIES
	{			
		LONG ID_CA_COLLISION_DEFORMER_OBJECT_COORDS
		{
			SCALE_H;
			
			CYCLE
			{
				ID_CA_COLLISION_DEFORMER_OBJECT_COORDS_NONE;
				ID_CA_COLLISION_DEFORMER_OBJECT_COORDS_UV;
				ID_CA_COLLISION_DEFORMER_OBJECT_COORDS_LENGTH;
				ID_CA_COLLISION_DEFORMER_OBJECT_COORDS_SURFACE;
				ID_CA_COLLISION_DEFORMER_OBJECT_COORDS_COLLIDER;
			}
		}
		
		REAL ID_CA_COLLISION_DEFORMER_OBJECT_DISTANCE { UNIT METER; MIN 0.0; MAXSLIDER 1000.0; CUSTOMGUI REALSLIDER; }
		REAL ID_CA_COLLISION_DEFORMER_OBJECT_FALLOFF_STRENGTH { UNIT PERCENT; MIN 0.0; MAXSLIDER 200.0; CUSTOMGUI REALSLIDER; }
		
		REAL ID_CA_COLLISION_DEFORMER_OBJECT_RESTORESHAPE { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		
		SPLINE ID_CA_COLLISION_DEFORMER_OBJECT_FALLOFF
		{
			ALLOW_VERT_SCALE_MOVE;
			USE_OPTIMAL_RANGE;
		
			X_MIN 0;
			X_MAX 1;
			OPTIMAL_X_MIN 0;
			OPTIMAL_X_MAX 1;
						
			OPTIMAL_Y_MIN 0;
			OPTIMAL_Y_MAX 1;
			Y_MIN -1;
			Y_MAX 1;
		}
	}
	
	GROUP ID_CA_COLLISION_GROUP_COLLIDERS
	{
		SCALE_V;
		
		LONG ID_CA_COLLISION_DEFORMER_MOTION
		{
			SCALE_H;
			
			CYCLE
			{
				ID_CA_COLLISION_DEFORMER_MOTION_INSIDE;
				ID_CA_COLLISION_DEFORMER_MOTION_INSIDE_STRETCH;
				ID_CA_COLLISION_DEFORMER_MOTION_OUTSIDE;
				ID_CA_COLLISION_DEFORMER_MOTION_OUTSIDE_FULL;
				ID_CA_COLLISION_DEFORMER_MOTION_INTERSECT;
			}
		}
		
		IN_EXCLUDE  ID_CA_COLLISION_DEFORMER_OBJECT_COLLIDERS
		{
			NUM_FLAGS 2; INIT_STATE 3; SEND_SELCHNGMSG 1; SCALE_V;
			IMAGE_01_ON 1009316; IMAGE_01_OFF 1009320;
			IMAGE_02_ON 300000231; IMAGE_02_OFF 300000230;
			ACCEPT { Obase; Tbase; };
		}	
	}
	
	GROUP ID_CA_COLLISION_GROUP_INCLUDE
	{
		SCALE_V;
		
		IN_EXCLUDE  ID_CA_COLLISION_DEFORMER_OBJECTS
		{
			NUM_FLAGS 1; INIT_STATE 1; SEND_SELCHNGMSG 1; SCALE_V;
			IMAGE_01_ON 1009316; IMAGE_01_OFF 1009320;
			ACCEPT { Obase; Tbase; };
		}	
	}
	
	GROUP ID_CA_COLLISION_GROUP_MAPS
	{	
		LINK ID_CA_COLLISION_DEFORMER_OBJECT_STRETCH_MAP { ACCEPT { 5682; } }	
		LINK ID_CA_COLLISION_DEFORMER_OBJECT_FALLOFF_MAP { ACCEPT { 5682; } }
		LINK ID_CA_COLLISION_DEFORMER_OBJECT_RESTORE_MAP { ACCEPT { 5682; } }
	
		GROUP ID_CA_COLLISION_GROUP_MAPS_OUTPUT
		{	
			COLUMNS 2;
		
			LINK ID_CA_COLLISION_DEFORMER_OBJECT_COLLISION_MAP { ACCEPT { 5682; } }
			BOOL ID_CA_COLLISION_DEFORMER_OBJECT_COLLISION_MAP_INVERT { }
		
			LINK ID_CA_COLLISION_DEFORMER_OBJECT_DISTANCE_MAP { ACCEPT { 5682; } }
			BOOL ID_CA_COLLISION_DEFORMER_OBJECT_DISTANCE_MAP_INVERT { }
		}
	}
	
	GROUP ID_CA_COLLISION_DEFORMER_OBJECT_CACHE_GROUP
	{
		BOOL ID_CA_COLLISION_DEFORMER_OBJECT_CACHE_ENABLE { }

		SEPARATOR { LINE; }

		GROUP
		{
			COLUMNS 2;

			BOOL ID_CA_COLLISION_DEFORMER_OBJECT_CACHE_COMPRESSED { SCALE_H; ANIM OFF; }
			STATICTEXT ID_CA_COLLISION_DEFORMER_OBJECT_CACHE_INFO2 { SCALE_H; }

			BUTTON ID_CA_COLLISION_DEFORMER_OBJECT_CACHE_CALCULATE {  SCALE_H; }
			BUTTON ID_CA_COLLISION_DEFORMER_OBJECT_CACHE_UPDATE {  SCALE_H; }
			
			BUTTON ID_CA_COLLISION_DEFORMER_OBJECT_CACHE_DELETE { SCALE_H; }
			STATICTEXT { DUMMY; SCALE_H; }
			
			BUTTON ID_CA_COLLISION_DEFORMER_OBJECT_CACHE_CACHE_LOAD {  SCALE_H; }
			BUTTON ID_CA_COLLISION_DEFORMER_OBJECT_CACHE_CACHE_SAVE {  SCALE_H; }
			
			BOOL ID_CA_COLLISION_DEFORMER_OBJECT_CACHE_AUTOTIME { SCALE_H; ANIM OFF; }
			STATICTEXT { DUMMY; SCALE_H; }

			BASETIME ID_CA_COLLISION_DEFORMER_OBJECT_CACHE_START { SCALE_H; ANIM OFF; }
			BASETIME ID_CA_COLLISION_DEFORMER_OBJECT_CACHE_STOP  { SCALE_H; ANIM OFF; }
			
			BASETIME ID_CA_COLLISION_DEFORMER_OBJECT_CACHE_OFFSET { SCALE_H; ANIM OFF; }			
			REAL ID_CA_COLLISION_DEFORMER_OBJECT_CACHE_TIMESCALE { UNIT PERCENT; MIN 0.0; SCALE_H; }
			
			SEPARATOR { }
			STATICTEXT { JOINENDSCALE; }

			LONG ID_CA_COLLISION_DEFORMER_OBJECT_CACHE_CACHE_LIMIT { MIN 1; MAX 1000; ANIM OFF; }
			STATICTEXT ID_CA_COLLISION_DEFORMER_OBJECT_CACHE_TEXT_LIMIT {}
		}
	}
	
	GROUP ID_CA_COLLISION_GROUP_ADVANCED
	{
		GROUP
		{
			COLUMNS 2;
					
			REAL ID_CA_COLLISION_DEFORMER_OBJECT_SIZE { UNIT METER; }
			LONG ID_CA_COLLISION_DEFORMER_OBJECT_SAMPLING { MIN 1; }
			
			LONG ID_CA_COLLISION_DEFORMER_OBJECT_ITER { MIN 0; }
			LONG ID_CA_COLLISION_DEFORMER_OBJECT_RELAX_ITER { MIN 0; }
		}
		
		REAL ID_CA_COLLISION_DEFORMER_OBJECT_STIFF { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		REAL ID_CA_COLLISION_DEFORMER_OBJECT_STRUCT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		REAL ID_CA_COLLISION_DEFORMER_OBJECT_FLEX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
	}
}
