#ifndef VPGPURENDERER_H__
#define VPGPURENDERER_H__

enum
{
	VP_GPURENDERER_ANTIALIASING_SAMPLES_OFFLINE = 1000,
	VP_GPURENDERER_ANTIALIASING_SAMPLES_PREVIEW = 1001,
	
	// TODO: (Jochen | Justus) please remove these properly once we have confirmation that we won't need them anymore
	VP_GPURENDERER_ANTIALIASING_CELLSIZE_OFFLINE = 1002,
	VP_GPURENDERER_ANTIALIASING_CELLSIZE_PREVIEW = 1003,
	VP_GPURENDERER_ANTIALIASING_CELLSIZE_1 = 0,
	VP_GPURENDERER_ANTIALIASING_CELLSIZE_3 = 1,
	VP_GPURENDERER_ANTIALIASING_CELLSIZE_5 = 2,
	VP_GPURENDERER_ANTIALIASING_CELLSIZE_7 = 3,
	VP_GPURENDERER_ANTIALIASING_CELLSIZE_9 = 4,
	
	VP_GPURENDERER_FILTERMODE_OFFLINE = 1004,
	VP_GPURENDERER_FILTERMODE_PREVIEW = 1005,
	VP_GPURENDERER_FILTERMODE_NONE = 0,
	VP_GPURENDERER_FILTERMODE_BOX = 1,
	VP_GPURENDERER_FILTERMODE_TRIANGLE = 2,
	VP_GPURENDERER_FILTERMODE_GAUSSIAN = 3,
	VP_GPURENDERER_FILTERMODE_MITCHELL = 4,
	VP_GPURENDERER_FILTERMODE_LANCZOS = 5,
	VP_GPURENDERER_FILTERMODE_BLACKMANHARRIS = 6,
	
	VP_GPURENDERER_FILTERSIZE_OFFLINE = 1006,
	VP_GPURENDERER_FILTERSIZE_PREVIEW = 1007,
	
	VP_GPURENDERER_RECURSION_DEPTH_OFFLINE = 1008,
	VP_GPURENDERER_RECURSION_DEPTH_PREVIEW = 1009,
	
	VP_GPURENDERER_RADIANCE_CLAMP_OFFLINE = 1010,
	VP_GPURENDERER_RADIANCE_CLAMP_PREVIEW = 1011,
	
	VP_GPURENDERER_RENDERMODE_OFFLINE = 1012,
	VP_GPURENDERER_RENDERMODE_PREVIEW = 1013,
	VP_GPURENDERER_RENDERMODE_GLOBAL_ILLUMINATION = 1,
	VP_GPURENDERER_RENDERMODE_AMBIENT_OCCLUSION = 9,
	VP_GPURENDERER_RENDERMODE_DIRECT_ILLUMINATION = 10,
	VP_GPURENDERER_RENDERMODE_WIREFRAME = 11,
	VP_GPURENDERER_RENDERMODE_DIFFUSE = 12,
	
	VP_GPURENDERER_DEPTH_OF_FIELD_OFFLINE = 1014,
	VP_GPURENDERER_DEPTH_OF_FIELD_PREVIEW = 1015,
	
	VP_GPURENDERER_REFRESH_MODE = 1016,
	VP_GPURENDERER_REFRESH_MODE_TIME = 0,
	VP_GPURENDERER_REFRESH_MODE_ITERATIONS = 1,
	
	VP_GPURENDERER_REFRESH_ITERATIONS = 1017,
	VP_GPURENDERER_REFRESH_TIME = 1018,
	
	VP_GPURENDERER_RAY_EPSILON = 1019,
	// VP_GPURENDERER_RAY_EPSILON_PREVIEW = 1020,
	
	VP_GPURENDERER_RADIANCE_CLAMP_ENABLED_OFFLINE = 1021,
	VP_GPURENDERER_RADIANCE_CLAMP_ENABLED_PREVIEW = 1022,
	
	VP_GPURENDERER_BUCKET_RENDERING_ENABLED = 1023,
	VP_GPURENDERER_BUCKET_RENDERING_BUCKETSIZEX = 1024,
	VP_GPURENDERER_BUCKET_RENDERING_BUCKETSIZEY = 1025,
	VP_GPURENDERER_BUCKET_RENDERING_BUCKETSEQUENCE = 1026,
	VP_GPURENDERER_BUCKET_RENDERING_BUCKETSEQUENCE_CENTERED = 0,
	VP_GPURENDERER_BUCKET_RENDERING_BUCKETSEQUENCE_LEFTTORIGHT = 1,
	VP_GPURENDERER_BUCKET_RENDERING_BUCKETSEQUENCE_RIGHTTOLEFT = 2,
	VP_GPURENDERER_BUCKET_RENDERING_BUCKETSEQUENCE_TOPTOBOTTOM = 3,
	VP_GPURENDERER_BUCKET_RENDERING_BUCKETSEQUENCE_BOTTOMTOTOP = 4,
	
	VP_GPURENDERER_RESOLUTION_MAX_PREVIEW = 1028,
	VP_GPURENDERER_RESOLUTION_PREVIEW_1 = 1,
	VP_GPURENDERER_RESOLUTION_PREVIEW_2 = 2,
	VP_GPURENDERER_RESOLUTION_PREVIEW_4 = 3,
	VP_GPURENDERER_RESOLUTION_PREVIEW_8 = 4,
	VP_GPURENDERER_RESOLUTION_PREVIEW_16 = 5,
	
	VP_GPURENDERER_DEFAULT_LIGHT = 1029,
	
	VP_GPURENDERER_TEXSIZEX_OFFLINE = 1030,
	VP_GPURENDERER_TEXSIZEX_PREVIEW = 1031,
	VP_GPURENDERER_TEXSIZEY_OFFLINE = 1032,
	VP_GPURENDERER_TEXSIZEY_PREVIEW = 1033,
	VP_GPURENDERER_BITDEPTH_OFFLINE = 1034,
	VP_GPURENDERER_BITDEPTH_PREVIEW = 1035,
	VP_GPURENDERER_BITDEPTH_8 = 0,
	VP_GPURENDERER_BITDEPTH_32 = 1,
	
	VP_GPURENDERER_AO_RAY_LENGTH_OFFLINE = 1036,
	VP_GPURENDERER_AO_RAY_LENGTH_PREVIEW = 1037,
	
	VP_GPURENDERER_STATIC_NOISE = 1038,
	VP_GPURENDERER_LOD = 1039,
	VP_GPURENDERER_USELOD = 1040,
	
	VP_GPURENDERER_SHOWHUD = 1041,
	VP_GPURENDERER_RENDERDOODLE = 1042,
	
	VP_GPURENDERER_MOTION_BLUR_TYPE_OFFLINE = 1043,
	VP_GPURENDERER_MOTION_BLUR_TYPE_NONE = 0,
	VP_GPURENDERER_MOTION_BLUR_TYPE_LINEAR = 1,
	VP_GPURENDERER_MOTION_BLUR_TYPE_SFMB = 2,
	
	VP_GPURENDERER_SEED = 1044,
	VP_GPURENDERER_MOTION_BLUR_SFMB_SAMPLES = 1045,
	VP_GPURENDERER_MOTION_BLUR_SFMB_SAMPLES_5 = 0,
	VP_GPURENDERER_MOTION_BLUR_SFMB_SAMPLES_9 = 1,
	VP_GPURENDERER_MOTION_BLUR_SFMB_SAMPLES_16 = 2,
	VP_GPURENDERER_MOTION_BLUR_SFMB_SAMPLES_25 = 3,
	VP_GPURENDERER_MOTION_BLUR_SFMB_SAMPLES_36 = 4,
	VP_GPURENDERER_MOTION_BLUR_SFMB_SAMPLES_49 = 5,
	
	VP_GPURENDERER_MOTION_BLUR_SFMB_DITHERING = 1046,
	VP_GPURENDERER_RELOAD_SCENE_PER_FRAME = 1047,
	
	VP_GPURENDERER_RECURSION_DEPTH_DIFFUSE_OFFLINE = 1200,
	VP_GPURENDERER_RECURSION_DEPTH_DIFFUSE_PREVIEW = 1201,
	VP_GPURENDERER_RECURSION_DEPTH_GLOSSY_OFFLINE = 1202,
	VP_GPURENDERER_RECURSION_DEPTH_GLOSSY_PREVIEW = 1203,
	VP_GPURENDERER_RECURSION_DEPTH_REFRACTIVE_GLOSSY_OFFLINE = 1204,
	VP_GPURENDERER_RECURSION_DEPTH_REFRACTIVE_GLOSSY_PREVIEW = 1205,
	VP_GPURENDERER_RECURSION_DEPTH_REFRACTIVE_OFFLINE = 1206,
	VP_GPURENDERER_RECURSION_DEPTH_REFRACTIVE_PREVIEW = 1207,
	VP_GPURENDERER_SHADOW_DEPTH_OFFLINE = 1208,
	VP_GPURENDERER_SHADOW_DEPTH_PREVIEW = 1209,

	VP_GPURENDERER_OOC_TEXTURE_CACHE = 1210,
	VP_GPURENDERER_OOC_TEXTURE_CACHE_MODE = 1211,
	VP_GPURENDERER_OOC_TEXTURE_CACHE_MODE_MEM = 0,
	VP_GPURENDERER_OOC_TEXTURE_CACHE_MODE_DISK = 1,
	VP_GPURENDERER_OOC_TEXTURE_CACHE_ENABLED = 1212,

	VP_GPURENDERER_DEVICE_GROUP_OFFLINE = 2000,
	VP_GPURENDERER_DEVICE_GROUP_PREVIEW = 2001,
	VP_GPURENDERER_REFRESH_GROUP = 2002,
	VP_GPURENDERER_STOP_RENDERING_GROUP_OFFLINE = 2003,
	VP_GPURENDERER_STOP_RENDERING_GROUP_PREVIEW = 2004,
	VP_GPURENDERER_BUCKET_RENDERING_GROUP = 2005,
	VP_GPURENDERER_RESOLUTION_GROUP_PREVIEW = 2006,
	VP_GPURENDERER_GROUP_DEVICES = 2007,
	VP_GPURENDERER_DEFAULT_TEXRES_GROUP_PREVIEW = 2008,
	VP_GPURENDERER_DEFAULT_TEXRES_GROUP_OFFLINE = 2009,
	VP_GPURENDERER_MULTIPASS_GROUP = 2010,
	VP_GPURENDERER_MULTIPASS_AA_GROUP = 2011,
	VP_GPURENDERER_OOC_GROUP = 2012,
	
	VP_GPURENDERER_RENDER_ITERATIONS_MODE_OFFLINE = 3000,
	VP_GPURENDERER_RENDER_ITERATIONS_MODE_PREVIEW = 3001,
	VP_GPURENDERER_RENDER_ITERATIONS_MODE_ITERATIONS = 0,
	VP_GPURENDERER_RENDER_ITERATIONS_MODE_TIME = 1,
	VP_GPURENDERER_RENDER_ITERATIONS_MODE_INFINITE = 2,
	VP_GPURENDERER_RENDER_ITERATIONS_MODE_THRESHOLD = 3,
	
	VP_GPURENDERER_RENDER_TIME_OFFLINE = 3002,
	VP_GPURENDERER_RENDER_TIME_PREVIEW = 3003,
	VP_GPURENDERER_RENDER_ITERATIONS_OFFLINE = 3004,
	VP_GPURENDERER_RENDER_ITERATIONS_PREVIEW = 3005,
	VP_GPURENDERER_RENDER_THRESHOLD_OFFLINE = 3006,
	VP_GPURENDERER_RENDER_ITERATIONS_MAX = 3007,
	
	VP_GPURENDERER_FIREFLY_FILTER_ENABLE = 4001,
	VP_GPURENDERER_FIREFLY_FILTER_THRESHOLD = 4002,
	
	VP_GPURENDERER_MULTIPASS_ENABLE = 5000,
	
	VP_GPURENDERER_MULTIPASS_DIRECT_ILLUMINATION = 5011,
	VP_GPURENDERER_MULTIPASS_INDIRECT_ILLUMINATION = 5012,
	VP_GPURENDERER_MULTIPASS_EMISSION = 5013,
	VP_GPURENDERER_MULTIPASS_BACKGROUND = 5014,
	
	VP_GPURENDERER_MULTIPASS_WORLD_COORD = 5050,
	VP_GPURENDERER_MULTIPASS_UV = 5051,
	VP_GPURENDERER_MULTIPASS_MATERIAL_ID = 5052,
	VP_GPURENDERER_MULTIPASS_GEOMETRIC_NORMAL = 5053,
	VP_GPURENDERER_MULTIPASS_SHADING_NORMAL = 5054,
	VP_GPURENDERER_MULTIPASS_DEPTH = 5055,
	VP_GPURENDERER_MULTIPASS_OBJECT_ID = 5056,
	VP_GPURENDERER_MULTIPASS_OBJECT_GROUP_ID = 5058,
	
	VP_GPURENDERER_MULTIPASS_WORLD_COORD_ALIASED = 5150,
	VP_GPURENDERER_MULTIPASS_UV_ALIASED = 5151,
	VP_GPURENDERER_MULTIPASS_MATERIAL_ID_ALIASED = 5152,
	VP_GPURENDERER_MULTIPASS_GEOMETRIC_NORMAL_ALIASED = 5153,
	VP_GPURENDERER_MULTIPASS_SHADING_NORMAL_ALIASED = 5154,
	VP_GPURENDERER_MULTIPASS_DEPTH_ALIASED = 5155,
	VP_GPURENDERER_MULTIPASS_OBJECT_ID_ALIASED = 5156,
	VP_GPURENDERER_MULTIPASS_OBJECT_GROUP_ID_ALIASED = 5158,
	
	// 8000 to 8099 is reserved for the GPU devices!
	VP_GPURENDERER_DEVICES_OFFLINE = 8000,
	VP_GPURENDERER_DEVICES_PREVIEW = 8050,
	VP_GPURENDERER_DEVICE_CPU_OFFLINE = 8100,
	VP_GPURENDERER_DEVICE_CPU_PREVIEW = 8101,
	VP_GPURENDERER_DEVICES_OVERRIDE_PREFS = 8103,
	
	// 8200 to 8250 is reserved for the GPU devices to print "recommended"
	VP_GPURENDERER_DEVICE_STATIC_TEXT = 8200,
	
	// PAGES
	VP_GPURENDERER_PAGE_OFFLINE = 9000,
	VP_GPURENDERER_PAGE_PREVIEW = 9001,
	VP_GPURENDERER_PAGE_GENERAL = 9002,
	VP_GPURENDERER_PAGE_MULTIPASS = 9003,
	
	VP_GPURENDERER_PAGE_EXPERIMENTAL = 10000,
	// VP_GPURENDERER_MULTIPASS_VELOCITY = 10001,
	VP_GPURENDERER_MULTIPASS_AO = 10002,
	VP_GPURENDERER_MULTIPASS_DIRECT_DIFFUSE = 10003,
	VP_GPURENDERER_MULTIPASS_DIRECT_REFLECT = 10004,
	VP_GPURENDERER_MULTIPASS_INDIRECT_DIFFUSE = 10005,
	VP_GPURENDERER_MULTIPASS_INDIRECT_REFLECT = 10006,
	VP_GPURENDERER_MULTIPASS_REFRACT = 10007,
	VP_GPURENDERER_MULTIPASS_VOLUME = 10008,
	VP_GPURENDERER_MULTIPASS_ALBEDO = 10009,

	VP_GPURENDERER_MULTIPASS_RAW = 10014,
	
	VP_GPURENDERER_DUMMY
};

#endif // VPGPURENDERER_H__

